exports.name="Lookup";exports.version="0.2";exports.group="Standard";const{CSV,LookupSpec}=C.internal.Lookup;const{createHmac}=C.Crypto;const cLogger=C.util.getLogger("func:lookup");const ENV_ROLE="CRIBL_ROLE";const ENV_CONFIG_HELPER="CONFIG_HELPER";let table;let file;let addToEventFunc;let defaultValues;const QUOTE_REGEX=/(\\")/g;let guid;let logMultiple;let logCount;const maxLogMultiple=1e5;function quote(e){const t=e.replace(QUOTE_REGEX,"\\$1");return t.length===e.length&&!/\s/.test(e)?e:`"${t}"`}function addToRaw(e,t,o){if(!e._raw||!t||!o||!t.length||!o.length){return}let l=e._raw.length>0?",":"";for(let n=0;n<t.length&&n<o.length;n++){const i=o[n];if(i!==undefined){e._raw+=`${l}${quote(t[n])}=${quote(i||"")}`;l=","}}}exports.init=e=>{const t=e.conf||{};file=t.file;table=undefined;addToEventFunc=undefined;logCount=0;logMultiple=1;const o=t.matchMode||"exact";const l=t.matchType||"first";const n=t.outFields||[];const i=[];const u=[];const a=[];const r=[];defaultValues=[];if(file){CSV.validateFilePath(file)}return Promise.resolve().then((()=>{t.inFields.forEach((e=>{i.push(e.eventField);u.push(e.lookupField)}));defaultValues.fill(undefined,0,n.length);for(let e=0;e<n.length;e++){const t=n[e];a.push(t.eventField);r.push(t.lookupField);if(t.defaultValue!==undefined)defaultValues[e]=t.defaultValue}defaultValues=defaultValues.find((e=>e!=null))!=null?defaultValues:undefined;addToEventFunc=t.addToEvent?addToRaw:undefined;const e=t.ignoreCase||false;const d=+t.reloadPeriodSec||-1;guid=createHmac(file,`${o}${l}${e}${Date.now()}${process.env["CRIBL_WORKER_ID"]||""}`).substring(0,10);const s=new LookupSpec(i,r,u,a,false,e);cLogger.info("Creating Lookup",{matchMode:o,matchType:l,file,guid,confReloadPeriodSec:d});table=CSV.getReference(file,s,d,o,l);cLogger.info("Lookup created",{matchMode:o,matchType:l,file,guid,tableIsNull:table==null,actualReloadPeriodMs:table.getServicePeriod()});return table.ready().catch((e=>{if(e.code==="ENOENT"&&isConfigHelper()){cLogger.debug(`missing lookup file ${file} in cfg. helper`,{err:e,guid});return[{func:exports.name,severity:"warn",message:`The specified lookup file ${file} couldn't be found in this instance. Make sure it's present in Worker nodes.`}]}throw e}))}))};function isConfigHelper(){return process.env[ENV_ROLE]===ENV_CONFIG_HELPER}exports.unload=()=>{if(table){table.release();cLogger.info("unloaded lookup function",{path:file,id:table.getId(),remainingRefs:table.getRefCount(),guid})}else{cLogger.info("unloaded lookup function, no table present",{path:file,guid})}table=undefined};function logWithBackoff(e,t,o){if(++logCount%logMultiple===0){e(t,o??{});if(logMultiple<maxLogMultiple)logMultiple*=2}}exports.process=e=>{if(table){return table.ready().then((()=>{table.lookup(e,addToEventFunc,defaultValues);return e})).catch((t=>{logWithBackoff(cLogger.error,"lookup error",{error:t,file,guid,numErrors:logCount});return e}))}else{logWithBackoff(cLogger.warn,"called process() with no table: event is not modified",{file,guid,numErrors:logCount})}return e};exports.UT_getLookup=()=>process.env.NODE_ENV==="test"?table:undefined;