exports.name="EventStats";exports.version="0.1.0";exports.disabled=false;exports.handleSignals=true;exports.group=C.INTERNAL_FUNCTION_GROUP;exports.sync=true;const os=require("os");const AGG_NAME=/as\(([^)]+)\)$/;const DEFAULT_MAX_EVENTS=5e4;const logger=C.util.getLogger("func:eventstats");let aggOpts;let eventStore;let maxEvents;let aggregator;let aggregateNames;let groupBys;let hadFinal;let hitLimit;exports.init=e=>{const t=e.conf??{};if(!Array.isArray(t.aggregations)||t.aggregations.length===0){logger.warn("empty aggregation list in configuration",t);return}aggregateNames=[];for(let e=0;e<t.aggregations.length;++e){const r=t.aggregations[e];const n=r.match(AGG_NAME);if(n?.length!==2){logger.warn("invalid aggregation expression",{conf:t,aggregateExpression:r});throw new Error("failed to extract name out of aggregation expression")}aggregateNames.push(n[1])}maxEvents=t.maxEvents!=null?t.maxEvents:DEFAULT_MAX_EVENTS;if(maxEvents<1||!Number.isInteger(maxEvents)){logger.error("invalid value for maxEvents",{conf:t});throw new Error("maxEvents not specified within valid range (or not an integer")}if(t.groupBys?.length){groupBys=t.groupBys}aggOpts={cumulative:true,sufficientStatsOnly:false,hostname:os.hostname(),flushEventLimit:0,timeWindowSeconds:Number.MAX_SAFE_INTEGER,aggregations:t.aggregations,splitBys:groupBys,flushMemLimit:os.totalmem(),metricsMode:false,preserveSplitByStructure:true,searchAggMode:"CoordinatedSuppressPreview"};reset();logger.debug("initialized function",{conf:t,aggregateNames})};exports.unload=()=>{aggOpts=undefined;eventStore=undefined;aggregator=undefined;aggregateNames=undefined;groupBys=undefined};exports.process=e=>{if(!aggregator||!e||hadFinal&&e.__signalEvent__!=="reset")return e;if(e.__signalEvent__){switch(e.__signalEvent__){case"reset":logger.debug("received reset signal");reset();return e;case"final":if(e.__ctrlFields?.includes("cancel")||hadFinal)return e;hadFinal=true;case"complete_gen":return flushStats(aggregator.flush(true),e);default:return e}}else{if(eventStore.length>=maxEvents&&!hitLimit){logger.warn("exceeded the maximum, configured capacity",{maxEvents});hitLimit=true}if(!hitLimit)eventStore.push(e);const t=aggregator.aggregate(e);if(!t?.length)return undefined;return flushStats(t,e)}};function flushStats(e,t){if(!e?.length||!eventStore.length)return undefined;let r;let n;if(t.__signalEvent__){n=eventStore;eventStore=[]}else{n=[...eventStore]}if(groupBys){r=new Map;for(let t=0;t<e.length;++t){const n=e[t];if(n.__signalEvent__)continue;let g=r;for(let t=0;t<groupBys.length;++t){const r=String(n[groupBys[t]]);let a=g.get(r);if(t+1===groupBys.length){if(a!=null){logger.warn("multiple aggregates found for same groupBy combination",{aggregates:e});throw new Error("failed to group aggregates correctly")}g.set(r,n)}else{if(a==null){g.set(r,a=new Map)}g=a}}}}else{const t=e.filter((e=>e.__signalEvent__==null));if(t.length!==1){logger.warn("invalid/unexpected aggregator output (w/o groupBy)",{aggregates:e});throw new Error("failed to produce aggregates")}r=t[0]}for(let e=0;e<n.length;++e){const t=n[e];const g=groupBys?matchAggregate(t,r):r;if(g){aggregateNames.forEach((e=>t[e]=g[e]))}}const g=t.__clone(false,[]);g.__signalEvent__="reset";g.__setCtrlField("eventstats",t.__signalEvent__??"preview");n.unshift(g);if(t.__signalEvent__){n.push(t)}else{const e=t.__clone(false,[]);e.__signalEvent__="complete_gen";e.__setCtrlField("eventstats","preview");n.push(e)}return n}function matchAggregate(e,t){let r=t;for(let t=0;t<groupBys.length;++t){const n=String(e[groupBys[t]]);const g=r.get(n);if(!g){logger.info("missing aggregate in groupBy hierarchy",{sourceEvent:e});return undefined}if(t+1==groupBys.length){return g}r=g}}function reset(){aggregator=C.internal.Aggregation.aggregationMgr(aggOpts);eventStore=[];hadFinal=false;hitLimit=false}