const cLogger=C.util.getLogger("func:dns_lookup");const{NestedPropertyAccessor}=C.expr;const NodeCache=C.internal.NodeCache;const ResolveFileReader=C.internal.ResolveFileReader;const NOOP=()=>{};const dns=require("dns").promises;const net=require("net");exports.name="DNS Lookup";exports.version="0.2";exports.group="Standard";let _cache;const CACHE_MAX_SIZE=1e5;let _reverseLookupFields=[];let _dnsLookupFields=[];let _dnsServers;let _dnsResolver;let _domainOverrides=[];let _resolveFileDomains=null;let useResolveFile=false;let useLookup=false;let numErrors=0;const ERROR_THRESHOLD=1e3;exports.init=e=>{const r=e.conf||{};r.dnsLookupFields=r.dnsLookupFields||[];r.reverseLookupFields=r.reverseLookupFields||[];if(!r.dnsLookupFields.length&&!r.reverseLookupFields.length){throw new Error("Invalid arguments - Must specify at least 1 field to lookup!",r)}useLookup=r.lookupFallback||false;useResolveFile=r.useResolvConf||false;_dnsResolver=dns;_dnsServers=r.dnsServers||[];if(_dnsServers.length){try{_dnsResolver=new dns.Resolver;_dnsResolver.setServers(_dnsServers);cLogger.info("Using DNS overrides.",{dnsServers:_dnsServers})}catch(e){cLogger.error("Invalid DNS override(s)",{dnsServers:r.dnsServers,err:e});throw new Error("Invalid arguments - DNS overrides contain one or more invalid IP addresses! Check the logs for more details.",r)}}setUpFields(r.reverseLookupFields,_reverseLookupFields);setUpFields(r.dnsLookupFields,_dnsLookupFields,true);r.maxCacheSize=Number(r.maxCacheSize);r.maxCacheSize=Number.isNaN(r.maxCacheSize)?5e3:r.maxCacheSize;if(r.maxCacheSize>CACHE_MAX_SIZE)throw new Error(`Invalid argument - Max cache size allowed is ${CACHE_MAX_SIZE}`,r);r.cacheTTL=Number(r.cacheTTL);r.cacheTTL=Number.isNaN(r.cacheTTL)?30:r.cacheTTL;_domainOverrides=r.domainOverrides||[];if(r.cacheTTL>0){_cache=new NodeCache({stdTTL:r.cacheTTL*60,checkperiod:600,useClones:false,maxKeys:r.maxCacheSize})}};exports.process=e=>{const r=[];r.push(...reverseDnsLookup(e));r.push(...dnsLookup(e));return Promise.all(r).then((()=>e))};exports.unload=()=>{_cache=undefined;_dnsLookupFields=[];_reverseLookupFields=[];_dnsServers=undefined;_dnsResolver=undefined;_domainOverrides=[];_resolveFileDomains=null;useResolveFile=false;useLookup=false};function getDnsResolver(){return _dnsResolver}async function readResolveFileAndStoreInCache(){return ResolveFileReader.readResolveFile(cLogger).then((e=>{cLogger.info("resolv.conf domains added ",{domains:e});_resolveFileDomains=e})).catch((e=>{cLogger.warn(`failed to read '${ResolveFileReader.resolvFile}')`,{e});return Promise.reject(e)}))}const reverseFn=e=>getDnsResolver().reverse(e);function reverseDnsLookup(e){const r=[];for(let s=0;s<_reverseLookupFields.length;s++){const[o,n]=_reverseLookupFields[s];const t=(o.get(e)||"").trim();if(net.isIP(t)){const s=`ip_${t}`;const o=resolve(s,reverseFn,[t]).then((r=>{if(r!==null)n.set(e,r)})).catch(NOOP);r.push(o)}}return r}function lookupWithResolveFile(e,r){if(_resolveFileDomains===null){return readResolveFileAndStoreInCache().then((()=>shortnameWithDomainOverrideLookup(e,r,_resolveFileDomains)))}else{return shortnameWithDomainOverrideLookup(e,r,_resolveFileDomains)}}const lookupFn=async(e,r)=>{try{const s=await getDnsResolver().resolve(e,r);return extractRecords(s,r)}catch(e){if(!useResolveFile&&!_domainOverrides.length&&!useLookup)throw e}if(useResolveFile){try{return lookupWithResolveFile(e,r)}catch(e){if(!_domainOverrides.length&&!useLookup)throw e}}if(_domainOverrides.length){try{return shortnameWithDomainOverrideLookup(e,r,_domainOverrides)}catch(e){if(!useLookup)throw e}}return dns.lookup(e,r).then((e=>extractFromLookupCall(e,r)))};function extractRecords(e,r){if(r!=="ANY")return e;if(!Array.isArray(e))return e;if(e.length===1)return e;const s={};for(let r=0;r<e.length;r++){const{type:o,...n}=e[r];if(!s[o])s[o]=n;else if(Array.isArray(s[o]))s[o].push(n);else s[o]=[s[o],n]}return s}function extractFromLookupCall(e,r){const s=[];if(!Array.isArray(e)){e=[e]}for(let r=0;r<e.length;r++){s.push(e[r].address)}return extractRecords(s,r)}async function shortnameWithDomainOverrideLookup(e,r,s){for(const o of s){if(o==="."){continue}const s=`${e}.${o}`;cLogger.debug(`fallback looking up ${s}`);try{const e=await dns.resolve(s,r);if(e.length>0){return extractRecords(e,r)}}catch(e){}}throw new Error("fallback dns resolution found no results")}function dnsLookup(e){const r=[];for(let s=0;s<_dnsLookupFields.length;s++){const[o,n,t]=_dnsLookupFields[s];const i=(o.get(e)||"").trim();if(!net.isIP(i)){const s=`dns_${i}_${t}`;const o=resolve(s,lookupFn,[i,t]).then((r=>{if(r!==null)n.set(e,r)})).catch(NOOP);r.push(o)}}return r}const CACHE_THRESHOLD=5e3;async function resolve(e,r,s){if(_cache){const r=_cache.get(e);if((_cache.stats.hits+_cache.stats.misses)%CACHE_THRESHOLD===0){cLogger.debug("Cache stats",_cache.getStats())}if(r)return r}const o=new Promise((e=>{const o=Date.now();r(...s).then((r=>{if(Array.isArray(r)&&r.length===1)r=r[0];e(r)})).catch((r=>{handleError(r,{args:s});e(null)})).finally((()=>cLogger.debug(`dns took ${Date.now()-o}`,{args:s})))}));if(_cache)_cache.set(e,o);return o}const handleError=(e,r)=>{if(numErrors++%ERROR_THRESHOLD){cLogger.error("DNS Lookup error",{error:e,...r})}};function setUpFields(e,r,s){for(let o=0;o<e.length;o++){const n=e[o];const{inFieldName:t,outFieldName:i,resourceRecordType:l}=n;if(t&&t.length){const e=i&&i.length?i:t;const o=[new NestedPropertyAccessor(t),new NestedPropertyAccessor(e)];if(s)o.push(l||"A");r.push(o)}}}if(process.env.NODE_ENV==="test"){exports.getDnsCache=()=>_cache;exports.getDnsResolver=getDnsResolver}