exports.jobType="task-per-node";exports.waitForResults=true;exports.name="Filesystem search";exports.version="0.1";exports.disabled=false;const os=require("os");const _path=require("path");const{Generators:{fromFile,MergeSortGenerator,pipe},Path:{pathFilter},scopedResource,guid:getGuid}=C.internal;const{expr:{Expression},util:{injectFieldsToRawJsonString}}=C;let pathProvider;let filter;let contentFilter;let recurse;let dir;let batchSize;let maxResults;let resultsCount=0;let reverseResults;let compareExpression;let sortResults;let sortCursor;let addNodeFields;let rawResults;let eventMap;let hostname;let _guid;class FifoQueue{constructor(e){this.id=e;this.state={};this.tail=0;this.head=0;this._done=false}push(e){this.state[this.tail++]=e}next(){if(this.size()<=0)return undefined;const e=this.state[this.head];delete this.state[this.head];this.head++;if(this.head===this.tail){this.head=0;this.tail=0}return e}peek(){return this.state[this.head]}destroy(){this.state=undefined;this.head=0;this.tail=0;this._done=true}done(){this._done=true}isDone(){return this._done&&this.size()===0}isEmpty(){return!this._done&&this.size()===0}size(){return this.tail-this.head}}class MergeSortCursor{constructor(e,t){this._compare=e;this.map=new Map;this.sort=t}getQueue(e,t){let s=this.map.get(e);if(!s){t.debug("added queue",{taskId:e});s=new FifoQueue(e);this.map.set(e,s)}return s}putAt(e,t,s){const r=this.getQueue(e,s);if(!t)return;if(t.done){s.debug("queue done",{taskId:e});return r.done()}r.push(t)}remove(e){this.map.delete(e)}getQueues(){return Array.from(this.map.values())}getNext(){if(this.getQueues().some((e=>e.isEmpty())))return;if(!sortResults){return this.getUnsortedNext()}const e=this.getQueues().filter((e=>!e.isDone())).sort(((e,t)=>this._compare.evalOn({evtA:e.peek(),evtB:t.peek()})))[0];if(this.getQueues().some((e=>e.isEmpty())))return;return e&&e.next()}getUnsortedNext(){for(const e of this.map.values()){if(!e.isDone()){return e.next()}}return undefined}allDone(){return!this.getQueues().some((e=>!e.isDone()))}getMap(){return this.map}destroy(){this.getQueues().forEach((e=>e.destroy()));this.map=new Map}}function isDefined(e){return typeof e!=="undefined"}exports.initJob=async e=>{const{conf:t}=e.conf.executor;compareExpression=t.compareExpression&&new Expression(t.compareExpression,{disallowAssign:true});reverseResults=t.reverseResults!=null?t.reverseResults:false;maxResults=t.maxResults||1e3;sortResults=isDefined(compareExpression);resultsCount=0;sortCursor=new MergeSortCursor(compareExpression,sortResults);rawResults=t.rawResults!=null?t.rawResults:false};exports.jobOnAddedTask=async(e,t)=>{e.logger().debug("added task",{taskId:t});sortCursor.putAt(t,undefined,e.logger())};exports.jobOnTaskCompleted=async(e,t)=>{e.logger().info("completed task",{taskId:t});sortCursor.putAt(t,{done:true},e.logger())};exports.jobOnResult=async(e,t)=>{sortCursor.putAt(t.taskId,t,e.logger());let s=sortCursor.getNext();while(s&&resultsCount<maxResults){resultsCount++;try{await e.addResult(rawResults?s._raw+"\n":{content:s._raw,size:s._raw.length,file:s.file,taskId:s.taskId})}catch(e){resultsCount--;throw e}s=sortCursor.getNext()}if(sortCursor.allDone()||resultsCount>=maxResults){sortCursor.destroy();await e.finishJob()}};exports.initTask=async e=>{const t=e.conf;dir=C.os.resolvepath(t.path);if(dir==null)return Promise.reject(new Error("path is required"));recurse=t.recurse!=null?t.recurse:true;reverseResults=t.reverseResults!=null?t.reverseResults:false;filter=t.filter||"true";compareExpression=t.compareExpression&&new Expression(t.compareExpression,{disallowAssign:true});contentFilter=t.contentFilter&&new Expression(t.contentFilter,{disallowAssign:true});batchSize=t.resultBatchSize||10;maxResults=t.maxResults||1e3;resultsCount=0;sortResults=isDefined(compareExpression);addNodeFields=t.addNodeFields||false;hostname=os.hostname();_guid=getGuid();eventMap=addNodeFields?(e,t,s)=>{const r={host:hostname,source:t,guid:s};e._raw=injectFieldsToRawJsonString(e._raw,r);Object.assign(e,r);return e}:e=>e};exports.jobSeedTask=async()=>({dir,filter});exports.jobOnError=async()=>{};let files;exports.taskExecute=async e=>{files=[];const t=[];e.logger().debug("Directory",{dir});try{pathProvider=C.internal.Path.fileSystemProvider(recurse,dir);await pathProvider.init();const s=pathFilter(dir,filter,pathProvider,e.logger());let r=await s.getNextPath();while(!r.done){const e=r.val;t.push(e);r=await s.getNextPath()}}catch(t){await e.addResult({done:true});await e.reportError(t)}e.logger().debug("Files",{paths:t});files=(await Promise.all(t.map((async t=>{let s;try{s=await fromFile(t,undefined,reverseResults);s=reverseResults?s.jsonParse(true):s.byLines(true,true)}catch(t){e.reportError(t).catch((()=>{}))}return!!s&&s.map((e=>{const s=eventMap(e,t,_guid);s.time&&(s._time=new Date(s.time).getTime());s.file=t;return s})).filteredBy(contentFilter).execute()})))).filter((e=>!!e));if(files.length>1e3){e.logger().warn("Warning more than 1000 files opened on this task",{filesCount:files.length})}if(files.length){await scopedResource(pipe(new MergeSortGenerator(((e,t)=>compareExpression.evalOn({evtA:e,evtB:t})),files,sortResults)).byChunksOf(batchSize).execute(),(async t=>{let{value:s,done:r}=await t.next();while(!r&&(!maxResults||resultsCount<=maxResults)){const i=maxResults-resultsCount;const o=maxResults&&s.length>i?s.slice(0,i):s;await e.addResults(o);resultsCount+=o.length;({value:s,done:r}=await t.next())}await e.addResult({done:true})}));try{await Promise.all(files.map((async e=>e.destroy())))}catch(e){}}else{await e.addResult({done:true})}};exports.taskOnCancel=async()=>{try{files&&files.length&&await Promise.all(files.map((async e=>e.destroy())))}catch(e){}};