exports.name="Google Cloud Storage";exports.version="0.2";exports.disabled=false;exports.destroyable=false;let conf;let dir;let filter;let extractors;let bucketName;let provider;let batchSize;let endpoint;let creds;let mockClient;exports.init=e=>{conf=e.conf;dir=conf.path||"";filter=conf.filter||"true";batchSize=conf.maxBatchSize||10;mockClient=conf.mockClient;if(!conf.serviceAccountCredentials){throw new Error("Invalid Config - missing serviceAccountCredentials!")}try{creds=JSON.parse(conf.serviceAccountCredentials)}catch(e){throw new Error("Invalid config - serviceAccountCredentials expected to be in JSON format!")}validateCredentials(creds);bucketName=C.expr.runExprSafe(conf.bucket);endpoint=conf.endpoint||undefined;if(!bucketName){throw new Error("Invalid Config - missing bucket!")}provider=C.internal.Path.GoogleCloudProvider({recurse:conf.recurse||false,bucket:conf.bucket,credentials:creds,mockClient:conf.mockClient,endpoint,parquetChunkSizeMB:conf.parquetChunkSizeMB,parquetChunkDownloadTimeout:conf.parquetChunkDownloadTimeout});if(conf.extractors){extractors={};const{Expression:e}=C.expr;conf.extractors.forEach((r=>{extractors[r.key]=new e(r.expression)}))}exports.provider=provider;return provider.init()};function validateCredentials(e){if(!e.type||e.type!=="service_account"){throw new Error(`Invalid Config - unexpected service credentials type '${e.type}' type expected to be 'service_account'!`)}if(!e.project_id){throw new Error("Invalid Config - unexpected service credentials missing projectId")}}function reportErrorIfAny(e,r){if(r==null)return;e.reportError(r).catch((()=>{}))}exports.discover=async e=>{const r=C.internal.Path.pathFilter(dir,filter,provider,e.logger(),extractors);let t=await r.getNextPath();reportErrorIfAny(e,r.getLastError());const o=[];while(!t.done){const n={source:t.val,...t.meta};if(t.meta.fields)n.fields=t.meta.fields;if(t.val.endsWith(".gz"))n.compression="gzip";C.internal.Parquet.isParquetFile(t.val)?n.format="events":n.format="raw";o.push(n);if(o.length>=batchSize){await e.addResults(o);o.length=0}t=await r.getNextPath();reportErrorIfAny(e,r.getLastError())}await e.addResults(o)};exports.collect=async(e,r)=>{const t=e.source;r.logger().debug("Downloading file",{collectible:e,bucketName,fileName:t});return new Promise(((t,o)=>{const n=e=>{o(e)};try{const o=provider.createReadStream(e,r);o.once("error",n);o.once("readable",(()=>{o.off("error",n);t(o)}))}catch(e){n(e)}}))};exports.close=async()=>{await provider.close().catch((e=>{}))};