exports.name="Azure Blob";exports.version="0.2";exports.disabled=false;exports.destroyable=false;let conf;let dir;let filter;let extractors;let provider;let batchSize;let connectionString;let containerName;let mockClient;exports.init=e=>{conf=e.conf;dir=conf.path||"";filter=conf.filter||"true";batchSize=conf.maxBatchSize||10;mockClient=conf.mockClient;connectionString=conf.connectionString||process.env.AZURE_STORAGE_CONNECTION_STRING;containerName=C.expr.runExprSafe(conf.containerName);if(!connectionString){throw new Error("Invalid Config - connectionString not defined and not found in AZURE_STORAGE_CONNECTION_STRING environment variable")}if(!containerName){throw new Error("Invalid Config - missing container name")}provider=C.internal.Path.AzureBlobProvider({recurse:conf.recurse||false,containerName,credential:{authenticationMethod:"connection_string",connectionString},mockClient,includeMetadata:conf.includeMetadata!=null?conf.includeMetadata:true,includeTags:conf.includeTags!=null?conf.includeTags:true,parquetChunkSizeMB:conf.parquetChunkSizeMB,parquetChunkDownloadTimeout:conf.parquetChunkDownloadTimeout});if(conf.extractors){extractors={};const{Expression:e}=C.expr;conf.extractors.forEach((r=>{extractors[r.key]=new e(r.expression)}))}exports.provider=provider;return provider.init()};function reportErrorIfAny(e,r){if(r==null)return;e.reportError(r).catch((()=>{}))}exports.discover=async e=>{const r=C.internal.Path.pathFilter(dir,filter,provider,e.logger(),extractors);let t=await r.getNextPath();reportErrorIfAny(e,r.getLastError());const n=[];while(!t.done){const o={source:t.val,...t.meta};if(t.meta.fields)o.fields=t.meta.fields;if(t.val.endsWith(".gz"))o.compression="gzip";C.internal.Parquet.isParquetFile(t.val)?o.format="events":o.format="raw";n.push(o);if(n.length>=batchSize){await e.addResults(n);n.length=0}t=await r.getNextPath();reportErrorIfAny(e,r.getLastError())}await e.addResults(n)};exports.collect=async(e,r)=>{r.logger().debug("Downloading blob",{name:e.name});return new Promise(((t,n)=>{const o=e=>{n(e)};try{const n=provider.createReadStream(e,r);n.once("error",o);n.once("readable",(()=>{n.off("error",o);t(n)}))}catch(e){o(e)}}))};exports.close=async()=>{await provider.close().catch((e=>{}))};