const{spawn}=require("child_process");const cLogger=C.util.getLogger("func:tee");let proc;let hasFatalError=false;let lastEvent;let hasWrittenHeader;let restartProm;let unloading;exports.name="Tee";exports.version="0.2";exports.group="Advanced";const RESTART_DELAY=5e3;const RESTART_CODES=["EPIPE","ERR_STREAM_DESTROYED","ERR_STREAM_WRITE_AFTER_END"];function handleWriteError(r,e){if(restartProm)return;if(!hasWrittenHeader){cLogger.error(`write error. failed to write header.`,{reason:r,command:e.command,args:e.args});hasFatalError=true;return}cLogger.error(`write error.`,{error:r,pid:e.pid,command:e.command,args:e.args});const o=`Error: code=${r.code}, message=${r.message}`;const t=lastEvent;if(!r.code||RESTART_CODES.includes(r.code)||r.message==="write after end"){hasFatalError=true;if(e.restartOnExit){restartProcesss(e,o).then((()=>new Promise((r=>{if(t){Promise.resolve(exports.process(t,true)).then(r)}else{r()}})))).catch((r=>{}))}else{killProcess(o)}}}function handleProcessError(r,e){cLogger.error("process error",{error:r,pid:e.pid,command:e.command,args:e.args});const o=`Error: code=${r.code}, message=${r.message}`;killProcess(o)}function handleProcessExit(r,e,o){if(r>0&&o.restartOnExit||r===0&&o.restartOnExit&&hasWrittenHeader){cLogger.info("process exited, attempting to restart it.",{pid:o.pid,conf:o,code:r,signal:e});restartProcesss(o,"restarting after error.").catch((()=>{}))}else{cLogger.info("process exited",{pid:o.pid,conf:o,code:r,signal:e})}}function writeHeader(){if(proc&&proc.pid&&proc.stdin){hasWrittenHeader=proc.stdin.write(`${JSON.stringify({format:"json",conf:proc.conf})}\n`,"utf8",(r=>{if(r)hasWrittenHeader=false}))}}function startProcess(r,e){const o=Object.assign({},process.env,r.env||{});const t=Object.assign({},r);proc=spawn(r.command,r.args||[],{stdio:["pipe","ignore","ignore"],env:o});proc.conf=t;t.pid=proc.pid;cLogger.info("starting tee process",{reason:e,pid:proc.pid,conf:proc.conf});proc.on("error",(r=>handleProcessError(r,t)));proc.stdin.on("error",(r=>handleWriteError(r,t)));proc.on("exit",((r,e)=>handleProcessExit(r,e,t)));hasFatalError=false;writeHeader()}function restartProcesss(r,e){if(unloading)return Promise.reject();if(restartProm)return restartProm;cLogger.info(`restarting process in ${getRestartDelay()}ms`,{reason:e,pid:proc.pid,conf:proc.conf});restartProm=new Promise((e=>setTimeout((()=>{killProcess("restart");startProcess(r,"restart");restartProm=undefined;e()}),getRestartDelay())));return restartProm}function killProcess(r){if(proc){proc.removeListener("exit",handleProcessExit);proc.removeListener("error",handleProcessError);proc.stdin.removeListener("error",handleWriteError);cLogger.info("killing tee process",{reason:r,pid:proc.pid,conf:proc.conf});proc.stdin.end();proc.stdin.emit("drain");proc.kill();proc=null;hasWrittenHeader=false}}function getRestartDelay(){return process.env.NODE_ENV==="test"?1:RESTART_DELAY}exports.init=r=>{const e=r.conf||{};unloading=false;if(!e.command){cLogger.error('missing required conf field, "command"',{conf:e});return}startProcess(e,"init")};exports.unload=()=>{unloading=true;killProcess("unload");lastEvent=undefined;hasWrittenHeader=false};exports.process=r=>{if(!r)return r;lastEvent=r;if(proc&&!restartProm&&!hasFatalError&&hasWrittenHeader){if(proc.killed){handleWriteError(new Error("process has died"),{...proc.conf,pid:proc.pid})}else{const e=proc.stdin.write(`${r.asJSON()}\n`);if(!e){return new Promise((e=>{proc.stdin.once("drain",(()=>e(r)))})).catch((r=>{}))}}}return r};exports.UT_getProc=()=>proc;