exports.name="Store";exports.version="0.0.4";exports.disabled=false;exports.handleSignals=true;exports.group=C.INTERNAL_FUNCTION_GROUP;const logger=C.util.getLogger("func:store");const MAX_EVENT_DEFAULT=1e4;const COMPRESS_AUTO_SIZE=16384;const NEWLINE="\n";let maxEventDefault=MAX_EVENT_DEFAULT;let lookupRecordsLimit=C.internal.kusto.DEFAULT_SORT_MAX_EVENTS_IN_MEMORY;let compressAutoSize=COMPRESS_AUTO_SIZE;let destination;let description;let fieldMapping;let overwrite;let append;let tee;let compress;let separator=",";let maxEvents;let suppressPreviews;let totalEvents;let hadFinal;let hadReset;let outputBuffer;exports.init=async e=>{const t=e.conf;if(t.type!=="lookup"){throw new Error(`invalid store type: ${t.type}`)}if(!(destination=t.destination)){throw new Error(`destination required for store type ${t.type}`)}overwrite=t.mode==="overwrite";append=t.mode==="append";tee=t.tee??false;maxEvents=t.maxEvents??maxEventDefault;maxEvents=Math.min(lookupRecordsLimit,maxEvents);suppressPreviews=t.suppressPreviews??false;reset();if(append){const e=await C.internal.kusto.store.getLookupContentAndStoredMetadata(destination,true);if(!e){append=false}else if(e.meta.rows>=lookupRecordsLimit){throw new Error(`Lookup table ${destination} is too large to append content to`)}}if(!append){description=t.description;fieldMapping=t.fieldMapping;if(t.compress!=null){if(t.compress==="true"||t.compress===true){compress="true"}else if(t.compress==="false"||t.compress===false){compress="false"}else if(t.compress==="auto"){compress="auto"}else{throw new Error(`Invalid value for compress option: ${compress}`)}}else{compress="auto"}}else{const e=await C.internal.kusto.store.getLookupContentAndStoredMetadata(destination,false,lookupRecordsLimit);description=e.meta.description;compress=e.meta.compressed?"true":"auto";maxEvents=Math.min(e.content.totalCount+maxEvents,lookupRecordsLimit);totalEvents+=e.content.totalCount;if(totalEvents>maxEvents){throw new Error(`Lookup table ${destination} is too large to append content to`)}fieldMapping={};e.content.fields.forEach((e=>{if(e==="__id")return;fieldMapping[e]=e}));e.content.items.map((t=>{let o=Object.create(null);for(let n=0;n<t.length;++n){if(e.content.fields[n]==="__id")continue;o[e.content.fields[n]]=t[n]}outputBuffer.push(o)}))}};exports.process=async e=>{if(!e||hadFinal&&e.__signalEvent__!=="reset")return e;if(e.__signalEvent__){switch(e.__signalEvent__){case"timer":if(suppressPreviews)return e;return[createStatsEvent(e),e];case"final":if(e.__ctrlFields.includes("cancel"))return e;logger.debug("result generation triggered by final event",{event:e});hadFinal=true;const t=await storeCSV(e);if(!tee){return[t,e]}break;case"reset":if(hadReset){logger.error(`Unexpected 'reset' signal received`)}else{logger.debug(`'reset' signal received`)}hadReset=true;break;case"complete_gen":default:logger.silly("ignored signal event",{event:e})}return e}if(append){const t=Object.keys(fieldMapping);for(let o in e){if(!t.includes(o))delete e[o]}}++totalEvents;if(outputBuffer.length<maxEvents){outputBuffer.push(e)}if(tee){return e}return null};exports.unload=()=>{logger.debug("unloading store function");fieldMapping=undefined;outputBuffer=undefined};function reset(){outputBuffer=[];hadFinal=false;hadReset=false;totalEvents=0}function ensureFieldMapping(){if(fieldMapping)return;const e=new Set;for(const t of outputBuffer){for(const o of Object.keys(t)){if(!C.internal.criblInternalField(o)){e.add(o)}}}fieldMapping={};Array.from(e).sort().forEach((e=>fieldMapping[e]=e));logger.debug("determined field mapping for lookup output",fieldMapping)}function createStatsEvent(e){const t=e.__clone(true,[]);const o=outputBuffer.length;t._time=Date.now()/1e3;t.totalEventsOut=o;t.totalEventsDropped=totalEvents-o;return t}async function storeCSV(e){const t=new RegExp(`"|(${separator})`);const o=new RegExp('"',"g");const n=e=>{if(!t.test(e))return e;return`"${e.replace(o,'""')}"`};ensureFieldMapping();const s=Object.keys(fieldMapping);if(s.length===0){throw new Error(`Can't export to empty ${destination} lookup table with no lookup fields defined`)}const r=s.map((e=>n(fieldMapping[e]))).join(separator);const i=outputBuffer.map((e=>s.map((t=>{const o=e[t];if(o==null)return"";return n(String(o))})).join(separator))).join(NEWLINE);const a=[r,i].join(NEWLINE);let p=compress==="true"||compress==="auto"&&a.length>=compressAutoSize;const l={id:`${destination}.csv${p?".gz":""}`,description,size:a.length,content:a,rows:outputBuffer.length};await C.internal.kusto.store.writeLookupFile(l,overwrite||append);logger.debug("stored CSV content to lookup",{id:l.id,size:l.size,rows:l.rows});const u=createStatsEvent(e);u.totalBytesOut=l.size;u.lookupFile=l.id;outputBuffer=[];return u}exports.UT_setMaxEventDefault=e=>{maxEventDefault=e};exports.UT_setLookupRecordsLimit=e=>{lookupRecordsLimit=e};exports.UT_setAutoCompressSize=e=>{compressAutoSize=e};exports.UT_getMaxEventDefault=()=>maxEventDefault;exports.UT_getLookupRecordsLimit=()=>lookupRecordsLimit;exports.UT_getAutoCompressSize=()=>compressAutoSize;exports.UT_getOutputBuffer=()=>outputBuffer;