exports.name="Sort";exports.version="0.2";exports.disabled=false;exports.handleSignals=true;exports.group=C.INTERNAL_FUNCTION_GROUP;const{Expression}=C.expr;const logger=C.util.getLogger("func:sort");const DEFAULT_SORT_MAX_EVENTS_IN_MEMORY=C.internal.kusto.DEFAULT_SORT_MAX_EVENTS_IN_MEMORY;const SORT_FLUSH_INTERVAL=1e3;let sortProvider;let hadFinal;let externalFlushTrigger;let checkFlush;let lastFlush;let hadDataSinceFlush;let totalDataEvents;let lastPreviewEvents;let previewCount;let timeToFinal;let suppressPreviews;exports.init=e=>{const t=e.conf;if(t.comparisonExpression){const e=new Expression(t.comparisonExpression,{disallowAssign:true});const r=(t,r)=>{try{return e.evalOn({left:t,right:r})}catch(e){logger.warn("error during sort comparison",{error:e,left:t,right:r});return 0}};if(!(t.topN<DEFAULT_SORT_MAX_EVENTS_IN_MEMORY||t.maxEvents<DEFAULT_SORT_MAX_EVENTS_IN_MEMORY)){t.topN=DEFAULT_SORT_MAX_EVENTS_IN_MEMORY;logger.warn("applying implicit topN to sort",{conf:t})}const s={id:t.sortId??`sort-${Date.now()}`,compareFunction:r};if(t.topN)s.topN=t.topN;if(t.maxEvents)s.maxEvents=t.maxEvents;sortProvider=C.internal.kusto.createSort(s);hadFinal=false;checkFlush=true;externalFlushTrigger=false;hadDataSinceFlush=false;totalDataEvents=0;lastPreviewEvents=0;lastFlush=0;previewCount=0;suppressPreviews=t.suppressPreviews;logger.debug("created sort provider",{id:sortProvider.conf.id,type:sortProvider.type})}else{throw new Error("No comparison expression on sort configuration")}};exports.process=async e=>{if(!e||hadFinal&&e.__signalEvent__!=="reset")return e;if(e.__signalEvent__){switch(e.__signalEvent__){case"reset":logger.debug("resetting sort storage",{id:sortProvider.conf.id,event:e});sortProvider.reset();hadFinal=false;totalDataEvents=0;useExternalFlushTrigger(e);return e;case"complete_gen":logger.debug("preview generation triggered by complete event",{event:e});useExternalFlushTrigger(e);const t=flushPreview(e);if(t?.length){return t}return e;case"final":if(e.__ctrlFields.includes("cancel"))return e;logger.debug("result generation triggered by final event",{event:e});const r=[];hadFinal=true;if(hadDataSinceFlush||totalDataEvents>lastPreviewEvents){for await(const e of sortProvider.drain()){r.push(e)}if(!r.length)return e;const t=e.__clone(false,[]);t.__signalEvent__="reset";t.__setCtrlField("sort","final");r.unshift(t)}else{logger.debug("skipping result generation (no new data since last preview)")}r.push(e);timeToFinal=Date.now()-timeToFinal;logger.debug("done with sort (after final event)",{id:sortProvider.conf.id,stats:sortProvider.sortStats,previews:previewCount,totalTime:timeToFinal});return r;default:logger.silly("ignored signal event",{event:e});return e}}hadDataSinceFlush=true;++totalDataEvents;await sortProvider.addEvent(e);return checkFlushInterval()};function checkFlushInterval(){let e=null;if(checkFlush&&!hadFinal&&!suppressPreviews){const t=Date.now();checkFlush=false;let r=SORT_FLUSH_INTERVAL;if(lastFlush){const s=t-lastFlush;logger.debug("checking for implicit sort preview flush",{delta:s});if(!externalFlushTrigger){if(s>=SORT_FLUSH_INTERVAL){e=flushPreview();r=SORT_FLUSH_INTERVAL-(Date.now()-t)}else{r=SORT_FLUSH_INTERVAL-s}}}else{lastFlush=t;timeToFinal=t}if(!externalFlushTrigger){logger.debug("resetting timer for next preview flush",{delay:r});setTimeout((()=>checkFlush=true),r)}}return e?.length?e:null}function flushPreview(e){if(suppressPreviews)return[];hadDataSinceFlush=false;const t=sortProvider.preview().map((e=>e.__clone()));if(lastPreviewEvents=t.length){const r=t[0].__clone(false,[]);r.__signalEvent__="reset";r.__setCtrlField("sort","preview");t.unshift(r);if(e){t.push(e)}else{const e=r.__clone(false,[]);e.__signalEvent__="complete_gen";t.push(e)}++previewCount;logger.debug("created sorted preview",{id:sortProvider.conf.id,events:t.length-2,previews:previewCount})}lastFlush=Date.now();return t}function useExternalFlushTrigger(e){if(!externalFlushTrigger){externalFlushTrigger=true;logger.debug("switching to external flush trigger",{event:e})}}exports.unload=()=>{logger.debug("unloading sort function",{id:sortProvider.conf.id});sortProvider.reset()};