exports.name="Lookup";exports.version="0.2";exports.group="Standard";const{CSV,LookupSpec}=C.internal.Lookup;const{createHmac}=C.Crypto;const cLogger=C.util.getLogger("func:lookup");const ENV_ROLE="CRIBL_ROLE";const ENV_CONFIG_HELPER="CONFIG_HELPER";let table;let file;let addToEventFunc;let defaultValues;const QUOTE_REGEX=/(\\")/g;let guid;let logMultiple;let logCount;let isReady=false;const maxLogMultiple=1e5;function quote(e){const o=e.replace(QUOTE_REGEX,"\\$1");return o.length===e.length&&!/\s/.test(e)?e:`"${o}"`}function addToRaw(e,o,t){if(!e._raw||!o||!t||!o.length||!t.length){return}let l=e._raw.length>0?",":"";for(let n=0;n<o.length&&n<t.length;n++){const u=t[n];if(u!==undefined){e._raw+=`${l}${quote(o[n])}=${quote(u||"")}`;l=","}}}exports.init=e=>{const o=e.conf||{};file=o.file;table=undefined;addToEventFunc=undefined;logCount=0;logMultiple=1;const t=o.matchMode||"exact";const l=o.matchType||"first";const n=o.outFields||[];const u=[];const r=[];const i=[];const a=[];defaultValues=[];return Promise.resolve().then((()=>{o.inFields.forEach((e=>{u.push(e.eventField);r.push(e.lookupField)}));defaultValues.fill(undefined,0,n.length);for(let e=0;e<n.length;e++){const o=n[e];i.push(o.eventField);a.push(o.lookupField);if(o.defaultValue!==undefined)defaultValues[e]=o.defaultValue}defaultValues=defaultValues.find((e=>e!=null))!=null?defaultValues:undefined;addToEventFunc=o.addToEvent?addToRaw:undefined;const e=o.ignoreCase||false;const s=+o.reloadPeriodSec||-1;guid=createHmac(file,`${t}${l}${e}${Date.now()}${process.env["CRIBL_WORKER_ID"]||""}`).substring(0,10);const d=new LookupSpec(u,a,r,i,false,e);cLogger.info("Creating Lookup",{matchMode:t,matchType:l,file,guid,confReloadPeriodSec:s});table=CSV.getReference(file,d,s,t,l);cLogger.info("Lookup created",{matchMode:t,matchType:l,file,guid,tableIsNull:table==null,actualReloadPeriodMs:table.getServicePeriod()});return table.ready().catch((e=>{if(e.code==="ENOENT"&&isConfigHelper()){cLogger.debug(`missing lookup file ${file} in cfg. helper`,{error:e,guid});return[{func:exports.name,severity:"warn",message:`The specified lookup file ${file} couldn't be found in this instance. Make sure it's present in Worker nodes.`}]}throw e}))}))};function isConfigHelper(){return process.env[ENV_ROLE]===ENV_CONFIG_HELPER}exports.unload=()=>{if(table){table.release();cLogger.info("unloaded lookup function",{path:file,id:table.getId(),remainingRefs:table.getRefCount(),guid})}else{cLogger.info("unloaded lookup function, no table present",{path:file,guid})}table=undefined};function logWithBackoff(e,o,t){if(++logCount%logMultiple===0){e(o,t??{});if(logMultiple<maxLogMultiple)logMultiple*=2}}function processSync(e){try{table.lookup(e,addToEventFunc,defaultValues);return e}catch(o){logWithBackoff(cLogger.error,"lookup error",{error:o,file,guid,numErrors:logCount});return e}}function processAsync(e){return table.ready().then((()=>{isReady=true;table.lookup(e,addToEventFunc,defaultValues);return e})).catch((o=>{logWithBackoff(cLogger.error,"lookup error",{error:o,file,guid,numErrors:logCount});return e}))}exports.process=e=>{if(table){if(isReady){return processSync(e)}else{return processAsync(e)}}else{logWithBackoff(cLogger.warn,"called process() with no table: event is not modified",{file,guid,numErrors:logCount})}return e};exports.UT_getLookup=()=>process.env.NODE_ENV==="test"?table:undefined;