exports.name="lake_export";exports.version="0.0.1";exports.disabled=false;exports.handleSignals=true;exports.group=C.INTERNAL_FUNCTION_GROUP;let dataset,searchJobId,tee=false,flushMs=1e4,destination,destMeta,lastFlush,logger,_eventsOut=0,_deltaEventsMissingFields=0,_eventsMissingFields=0,_eventsSkippedFieldPartitioning=0,_bytesOut=0,countEventsWithMissingFields=false,suppressPreviews=false,receivedEvents=false,hadFinal=false,mock;exports.init=async e=>{const t=e.conf;({dataset,searchJobId,mock}=t);if(dataset==null){if(!searchJobId)throw new Error("searchJobId field is required")}logger=C.util.getLogger(`lakeExportFunction:${searchJobId}`);suppressPreviews=t.suppressPreviews;tee=t.tee??tee;flushMs=t.flushMs??flushMs;const s=await C.internal.kusto.lake.createLakeOutput(dataset,searchJobId,logger,mock);if(s==null||s.destination==null){throw new Error(`Couldn't export results to lake dataset '${dataset}'`)}destination=s.destination;destMeta=s.destMeta;countEventsWithMissingFields=destMeta&&destMeta.acceleratedFields&&destMeta.acceleratedFields.length>0;_eventsOut=0;_bytesOut=0;_eventsMissingFields=0;_eventsSkippedFieldPartitioning=0;logger.info("Initialized lake export",{dataset})};exports.process=async e=>{if(!e||hadFinal)return e;if(!tee&&e.__signalEvent__){switch(e.__signalEvent__){case"reset":case"complete_gen":return;case"timer":case"close":return flushStats(e);case"final":{await flushDest(e);const t=createStatsEvent(e,destination,true);const s=[e];if(_eventsMissingFields>0){const t=Object.assign(e.__clone(true,[]),{searchJobId,status:`Warning: ${_eventsMissingFields} events are missing accelerated fields - you should define the fields for performance purposes. Please refer to https://docs.cribl.io/lake/datasets/#accelerated-fields for more details on accelerated fields.`,_time:Date.now()/1e3});s.push(t)}if(_eventsSkippedFieldPartitioning>0){const t=Object.assign(e.__clone(true,[]),{searchJobId,status:`Warning: Could not accelerate fields for ${_eventsSkippedFieldPartitioning} events - string length was too long. Please refer to https://docs.cribl.io/lake/datasets/#accelerated-fields for more details on accelerated fields.`,_time:Date.now()/1e3});logger.warn("Export to lake skipped field acceleration",{_eventsSkippedFieldPartitioning});s.push(t)}s.push(t);return s}default:logger.warn("unhandled signal",{event:e});return e}}else if(e.__signalEvent__==="final"){await flushDest(e)}if(!tee&&countEventsWithMissingFields&&!e.__signalEvent__){for(const t of destMeta.acceleratedFields){if(!Object.hasOwn(e,t)){_deltaEventsMissingFields++;break}}}return await send(e,destination,tee)};exports.unload=()=>{destination=undefined;dataset=undefined;receivedEvents=false;hadFinal=false;lastFlush=undefined};async function flushDest(e){if(e.__ctrlFields.includes("cancel"))return e;logger.debug("Final flushing stats & destination");hadFinal=true;await destination.flush();await destination.close()}async function send(e,t,s=false){if(s){if(e.__signalEvent__)return e;const s=e.__clone();await t.send(s);return e}await t.send(e);return flushStats(e)}function createStatsEvent(e,t,s=false){const n=t.reportStatus();const i=e.__clone(true,[]);const{sentCount:a,bytesWritten:l,numEventsSkippedFieldPartition:r}=n.metrics;const o=a-_eventsOut;const d=l-_bytesOut;if(countEventsWithMissingFields){_eventsMissingFields+=_deltaEventsMissingFields}_eventsSkippedFieldPartitioning=r;if(!s&&d===0&&o===0)return undefined;let c="Exporting";if(s){c=e.__ctrlFields.includes("cancel")?"Exporting stopped due to errors or cancellation":"Exporting complete"}const u=Object.assign(i,{searchJobId,eventsOut:o,bytesOut:d,totalEventsOut:a,totalBytesOut:l,status:c,_time:Date.now()/1e3});_eventsOut=a;_bytesOut=l;return u}function flushStats(e){const t=Date.now();if(!receivedEvents){const t=[];receivedEvents=true;const s=e.__clone(true,[]);const n=Object.assign(s,{searchJobId,status:"Begin exporting",_time:Date.now()/1e3});t.push(n);if(e.__signalEvent__){t.push(e)}return t}if(!lastFlush)lastFlush=t;if(suppressPreviews||lastFlush+flushMs>=t){if(e.__signalEvent__){return e}return undefined}else{const s=[];if(e.__signalEvent__){s.push(e)}const n=createStatsEvent(e,destination);lastFlush=t;n&&s.push(n);return s.length?s:undefined}}exports.UT_getDestination=()=>destination;