exports.name="EventStats";exports.version="0.1.0";exports.disabled=false;exports.handleSignals=true;exports.group=C.INTERNAL_FUNCTION_GROUP;exports.sync=true;const os=require("os");const AGG_NAME=/as\(([^)]+)\)$/;const DEFAULT_MAX_EVENTS=5e4;const logger=C.util.getLogger("func:eventstats");let aggOpts;let eventStore;let maxEvents;let aggregator;let aggregateNames;let groupBys;let hadFinal;let hitLimit;let flushOnInputClose;exports.init=e=>{const t=e.conf??{};if(!Array.isArray(t.aggregations)||t.aggregations.length===0){logger.warn("empty aggregation list in configuration",t);return}flushOnInputClose=t.flushOnInputClose;aggregateNames=[];for(let e=0;e<t.aggregations.length;++e){const n=t.aggregations[e];const r=n.match(AGG_NAME);if(r?.length!==2){logger.warn("invalid aggregation expression",{conf:t,aggregateExpression:n});throw new Error("failed to extract name out of aggregation expression")}aggregateNames.push(r[1])}maxEvents=t.maxEvents!=null?t.maxEvents:DEFAULT_MAX_EVENTS;if(maxEvents<1||!Number.isInteger(maxEvents)){logger.error("invalid value for maxEvents",{conf:t});throw new Error("maxEvents not specified within valid range (or not an integer")}if(t.groupBys?.length){groupBys=t.groupBys}aggOpts={cumulative:true,sufficientStatsOnly:false,hostname:os.hostname(),flushEventLimit:0,timeWindowSeconds:Number.MAX_SAFE_INTEGER,aggregations:t.aggregations,splitBys:groupBys,flushMemLimit:os.totalmem(),metricsMode:false,preserveSplitByStructure:true,searchAggMode:"CoordinatedSuppressPreview",flushOnInputClose};reset();logger.debug("initialized function",{conf:t,aggregateNames})};exports.unload=()=>{aggOpts=undefined;eventStore=undefined;aggregator=undefined;aggregateNames=undefined;groupBys=undefined};exports.process=e=>{if(!aggregator||!e||hadFinal&&e.__signalEvent__!=="reset")return e;if(e.__signalEvent__){switch(e.__signalEvent__){case"reset":logger.debug("received reset signal");reset();return e;case"close":if(!flushOnInputClose)return e;case"final":if(e.__ctrlFields?.includes("cancel")||hadFinal)return e;hadFinal=true;case"complete_gen":return flushStats(aggregator.flush(true),e);default:return e}}else{if(eventStore.length>=maxEvents&&!hitLimit){logger.warn("exceeded the maximum, configured capacity",{maxEvents});hitLimit=true}if(!hitLimit)eventStore.push(e);const t=aggregator.aggregate(e);if(!t?.length)return undefined;return flushStats(t,e)}};function flushStats(e,t){if(!e?.length||!eventStore.length){if(t.__signalEvent__!=null)return t;return}let n;let r;if(t.__signalEvent__){r=eventStore;eventStore=[]}else{r=[...eventStore]}if(groupBys){n=new Map;for(let t=0;t<e.length;++t){const r=e[t];if(r.__signalEvent__)continue;let g=n;for(let t=0;t<groupBys.length;++t){const n=String(r[groupBys[t]]);let s=g.get(n);if(t+1===groupBys.length){if(s!=null){logger.warn("multiple aggregates found for same groupBy combination",{aggregates:e});throw new Error("failed to group aggregates correctly")}g.set(n,r)}else{if(s==null){g.set(n,s=new Map)}g=s}}}}else{const t=e.filter((e=>e.__signalEvent__==null));if(t.length!==1){logger.warn("invalid/unexpected aggregator output (w/o groupBy)",{aggregates:e});throw new Error("failed to produce aggregates")}n=t[0]}for(let e=0;e<r.length;++e){const t=r[e];const g=groupBys?matchAggregate(t,n):n;if(g){aggregateNames.forEach((e=>t[e]=g[e]))}}const g=t.__clone(false,[]);g.__signalEvent__="reset";g.__setCtrlField("eventstats",t.__signalEvent__??"preview");r.unshift(g);if(t.__signalEvent__){r.push(t)}else{const e=t.__clone(false,[]);e.__signalEvent__="complete_gen";e.__setCtrlField("eventstats","preview");r.push(e)}return r}function matchAggregate(e,t){let n=t;for(let t=0;t<groupBys.length;++t){const r=String(e[groupBys[t]]);const g=n.get(r);if(!g){logger.info("missing aggregate in groupBy hierarchy",{sourceEvent:e});return undefined}if(t+1==groupBys.length){return g}n=g}}function reset(){aggregator=C.internal.Aggregation.aggregationMgr(aggOpts);eventStore=[];hadFinal=false;hitLimit=false}