exports.name="Dynamic Sampling";exports.version="0.1";exports.group="Standard";exports.sync=true;const{Expression}=C.expr;const cLogger=C.util.getLogger("func:dynamic_sampling");const DEFAULT_PERIOD_SECS=30;const DEFAULT_MIN_EVENTS=30;const DEFAULT_MAX_SAMPLE_RATE=100;const SAMPLE_MODES={NONE:0,LOG:1,SQUARE_ROOT:2};let sampleMode=SAMPLE_MODES.NONE;let minEvents=DEFAULT_MIN_EVENTS;let maxSampleRate=DEFAULT_MAX_SAMPLE_RATE;let expression;let sampleGroupStats={};let samplePeriodMS;function setDefaultValues(){sampleMode=SAMPLE_MODES.NONE;minEvents=DEFAULT_MIN_EVENTS;maxSampleRate=DEFAULT_MAX_SAMPLE_RATE;expression;sampleGroupStats={};samplePeriodMS}exports.unload=()=>setDefaultValues();exports.init=e=>{setDefaultValues();const{conf:t}=e||{};sampleGroupStats={};expression=new Expression(`${t.keyExpr||true}`,{disallowAssign:true});samplePeriodMS=(t.samplePeriod||DEFAULT_PERIOD_SECS)*1e3;minEvents=t.minEvents>=0?t.minEvents:DEFAULT_MIN_EVENTS;maxSampleRate=Math.max(Math.floor(t.maxSampleRate||DEFAULT_MAX_SAMPLE_RATE),1);let s=t.mode;if(s&&s.toLowerCase()==="log"){sampleMode=SAMPLE_MODES.LOG}else if(s&&s.toLowerCase()==="sqrt"){sampleMode=SAMPLE_MODES.SQUARE_ROOT}else{s="log";sampleMode=SAMPLE_MODES.LOG}cLogger.info("Dynamic Sampling Initialized",{mode:`${s}-(${sampleMode})`,samplePeriodMS,minEvents,expression:expression.originalExpression})};exports.process=e=>{const t=expression.evalOn(e);let s=sampleGroupStats[t];const a=C.util.getEventTimeInMs(e)||Date.now();if(s===undefined){s={sampleRate:1,count:0,sampleIdx:1,nextUpdateTime:a+samplePeriodMS};sampleGroupStats[t]=s}else if(a>=s.nextUpdateTime){recalcSampleRate(t,s,a)}s.count++;if(s.sampleIdx++>=s.sampleRate){s.sampleIdx=1;e.sampled=s.sampleRate;return e}return undefined};function recalcSampleRate(e,t,s){if(t.count===0){t.count=0;t.sampleRate=1}else{const e=(s-t.nextUpdateTime)/samplePeriodMS;if(e>=1){t.count=0;t.sampleRate=1}else{t.sampleRate=Math.min(getSampleRate(t.count),maxSampleRate);t.sampleIdx=1+Math.floor(Math.random()*t.sampleRate);t.count=0}t.nextUpdateTime=s+samplePeriodMS}}function getSampleRate(e){if(!e||e<=minEvents){return 1}if(sampleMode===SAMPLE_MODES.LOG){return Math.ceil(Math.log(e))}else if(sampleMode===SAMPLE_MODES.SQUARE_ROOT){return Math.ceil(Math.sqrt(e))}return 1}exports.getSampleMode=()=>sampleMode;exports.getExpression=()=>expression;exports.getMinEvents=()=>minEvents;exports.getSamplePeriodMS=()=>samplePeriodMS;exports.getSampleGroupStats=()=>sampleGroupStats;exports.getSampleGroupStatsSize=()=>Object.keys(sampleGroupStats).length;