exports.name="Office 365 Service Communications";exports.version="0.1";exports.disabled=false;exports.hidden=true;exports.destroyable=false;const{httpSearch,isHttp200,RestVerb,HttpError,wrapExpr,DEFAULT_TIMEOUT_SECS}=C.internal.HttpUtils;let contentType;let tenantId;let appId;let clientSecret;let contentUrl;let exprArgs={};let earliest;let timeout;let authUrl;let retryRules;let resource;const CONTENT_CURRENT="CurrentStatus";const CONTENT_MESSAGES="Messages";exports.init=e=>{const t=e.conf;tenantId=t.tenant_id;appId=t.app_id;planType=t.plan_type;clientSecret=t.client_secret;contentType=t.content_type;if(![CONTENT_CURRENT,CONTENT_MESSAGES].includes(contentType)){throw new Error(`Invalid contentType: ${t.content_type}`)}exprArgs={tenantId,appId,clientSecret,contentType,planType};const r=["tenantId","appId","clientSecret"].filter((e=>!exprArgs[e]));if(r.length){throw new Error(`Invalid configuration missing: ${r}`)}resource=getContentRoot();if(contentType===CONTENT_CURRENT){contentUrl=`${resource}/v1.0/admin/serviceAnnouncement/healthOverviews`}else if(contentType===CONTENT_MESSAGES){contentUrl=`${resource}/v1.0/admin/serviceAnnouncement/messages`}const n=planType==="gcc_high"||planType==="dod"?"us":"com";authUrl=`https://login.microsoftonline.${n}/${tenantId}/oauth2/token`;earliest=t.earliest?new Date(t.earliest*1e3):undefined;timeout=t.timeout!=null&&+t.timeout>=0?+t.timeout:DEFAULT_TIMEOUT_SECS*1e3;retryRules=t.retryRules};function getContentRoot(){switch(planType){case"enterprise_gcc":case"gcc":return"https://graph.microsoft.com";case"gcc_high":return"https://graph.microsoft.us";case"dod":return"https://dod-graph.microsoft.us"}}function getCollectParams(){const e={};if(earliest&&contentType===CONTENT_MESSAGES){e["$filter"]=wrapExpr(`lastModifiedDateTime ge ${earliest.toISOString()}`)}return e}exports.discover=async e=>{await e.addResult({source:contentUrl,format:"raw"})};exports.collect=async(e,t)=>{const r={client_id:wrapExpr(exprArgs.appId),resource,client_secret:wrapExpr(exprArgs.clientSecret),grant_type:"'client_credentials'"};const n={url:authUrl,method:RestVerb.POST,params:r,exprArgs,timeout,retryRules};const o=await(await httpSearch({...n,logger:t.logger()})).extractResult("access_token");const s=getCollectParams();const c={url:e.source,params:s,method:RestVerb.GET,headers:{Authorization:wrapExpr(`Bearer ${o}`)},timeout,retryRules};const a=await httpSearch({...c,logger:t.logger()});a.res.on("end",(()=>{if(!isHttp200(a.res.statusCode)){const e=new HttpError("Office365 collect error",a.res.statusCode,{host:a.host,port:a.port,path:a.path,method:a.method});t.reportError(e,"JobFatal").catch((()=>{}))}})).on("error",(e=>{t.reportError(e,"JobFatal").catch((()=>{}))}));return a.stream()};