exports.name="Google Cloud Storage";exports.version="0.2";exports.disabled=false;exports.destroyable=false;let conf;let dir;let filter;let extractors;let bucketName;let provider;let batchSize;let endpoint;let creds;let mockClient;exports.init=e=>{conf=e.conf;dir=conf.path||"";filter=conf.filter||"true";batchSize=conf.maxBatchSize||10;mockClient=conf.mockClient;if(conf.authType!=="auto"){if(!conf.serviceAccountCredentials){throw new Error("Invalid Config - missing serviceAccountCredentials!")}try{creds=JSON.parse(conf.serviceAccountCredentials)}catch(e){throw new Error("Invalid config - serviceAccountCredentials expected to be in JSON format!")}validateCredentials(creds)}bucketName=C.expr.runExprSafe(conf.bucket);endpoint=conf.endpoint||undefined;if(!bucketName){throw new Error("Invalid Config - missing bucket!")}provider=C.internal.Path.GoogleCloudProvider({recurse:conf.recurse||false,bucket:conf.bucket,credentials:creds,mockClient:conf.mockClient,endpoint,parquetChunkSizeMB:conf.parquetChunkSizeMB,parquetChunkDownloadTimeout:conf.parquetChunkDownloadTimeout});if(conf.extractors){extractors={};const{Expression:e}=C.expr;conf.extractors.forEach((t=>{extractors[t.key]=new e(t.expression)}))}exports.provider=provider;return provider.init()};function validateCredentials(e){if(!e.type||e.type!=="service_account"){throw new Error(`Invalid Config - unexpected service credentials type '${e.type}' type expected to be 'service_account'!`)}if(!e.project_id){throw new Error("Invalid Config - unexpected service credentials missing projectId")}}function reportErrorIfAny(e,t){if(t==null)return;e.reportError(t).catch((()=>{}))}exports.discover=async e=>{const t=C.internal.Path.pathFilter(dir,filter,provider,e.logger(),extractors);let r=await t.getNextPath();reportErrorIfAny(e,t.getLastError());const o=[];while(!r.done){const n={source:r.val,...r.meta};if(r.meta.fields)n.fields=r.meta.fields;if(r.val.endsWith(".gz"))n.compression="gzip";C.internal.Parquet.isParquetFile(r.val)?n.format="events":n.format="raw";o.push(n);if(o.length>=batchSize){await e.addResults(o);o.length=0}r=await t.getNextPath();reportErrorIfAny(e,t.getLastError())}await e.addResults(o)};exports.collect=async(e,t)=>{const r=e.source;t.logger().debug("Downloading file",{collectible:e,bucketName,fileName:r});return new Promise(((r,o)=>{const n=e=>{o(e)};try{const o=provider.createReadStream(e,t);o.once("error",n);o.once("readable",(()=>{o.off("error",n);r(o)}))}catch(e){n(e)}}))};exports.close=async()=>{await provider.close().catch((e=>{}))};