#!/bin/bash

###############
CRIBL_BIN_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
CRIBL_HOME="$( cd "$( dirname "${CRIBL_BIN_DIR}" )" >/dev/null 2>&1 && pwd )"
###############

USAGE="Usage: $0 {start|stop|restart|reload|status}"

display_deprecated_err_msg() {
    echo 'cribl.sh is deprecated. Please use cribl command instead.'>&2
}

start_app() {
    ${CRIBL_HOME}/bin/cribl 'start'
}

stop_app() {
    ${CRIBL_HOME}/bin/cribl 'stop'
}

restart_app() {
    ${CRIBL_HOME}/bin/cribl 'restart'
}
status_app() {
    ${CRIBL_HOME}/bin/cribl 'status'
}

reload_app() {
    ${CRIBL_HOME}/bin/cribl 'reload'
}

display_deprecated_err_msg

case "$1" in
    start)
        start_app
    ;;

    stop)
        stop_app
    ;;

    restart)
        stop_app
        start_app
    ;;

    reload)
        reload_app
    ;;

    status)
        status_app
    ;;

    *)
        echo $USAGE
        exit 1
    ;;
esac

exit $?
