/*! For license information please see bson.bundle.js.LICENSE.txt */
(function e(t,r){if(typeof exports==="object"&&typeof module==="object")module.exports=r();else if(typeof define==="function"&&define.amd)define([],r);else{var n=r();for(var i in n)(typeof exports==="object"?exports:t)[i]=n[i]}})(global,(()=>(()=>{"use strict";var e={"./node_modules/bson/lib/binary.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.Binary=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/ensure_buffer.js");var o=r("./node_modules/bson/lib/uuid_utils.js");var s=r("./node_modules/bson/lib/uuid.js");var u=r("./node_modules/bson/lib/error.js");var f=function(){function e(t,r){if(!(this instanceof e))return new e(t,r);if(!(t==null)&&!(typeof t==="string")&&!ArrayBuffer.isView(t)&&!(t instanceof ArrayBuffer)&&!Array.isArray(t)){throw new u.BSONTypeError("Binary can only be constructed from string, Buffer, TypedArray, or Array<number>")}this.sub_type=r!==null&&r!==void 0?r:e.BSON_BINARY_SUBTYPE_DEFAULT;if(t==null){this.buffer=n.Buffer.alloc(e.BUFFER_SIZE);this.position=0}else{if(typeof t==="string"){this.buffer=n.Buffer.from(t,"binary")}else if(Array.isArray(t)){this.buffer=n.Buffer.from(t)}else{this.buffer=(0,i.ensureBuffer)(t)}this.position=this.buffer.byteLength}}e.prototype.put=function(t){if(typeof t==="string"&&t.length!==1){throw new u.BSONTypeError("only accepts single character String")}else if(typeof t!=="number"&&t.length!==1)throw new u.BSONTypeError("only accepts single character Uint8Array or Array");var r;if(typeof t==="string"){r=t.charCodeAt(0)}else if(typeof t==="number"){r=t}else{r=t[0]}if(r<0||r>255){throw new u.BSONTypeError("only accepts number in a valid unsigned byte range 0-255")}if(this.buffer.length>this.position){this.buffer[this.position++]=r}else{var i=n.Buffer.alloc(e.BUFFER_SIZE+this.buffer.length);this.buffer.copy(i,0,0,this.buffer.length);this.buffer=i;this.buffer[this.position++]=r}};e.prototype.write=function(e,t){t=typeof t==="number"?t:this.position;if(this.buffer.length<t+e.length){var r=n.Buffer.alloc(this.buffer.length+e.length);this.buffer.copy(r,0,0,this.buffer.length);this.buffer=r}if(ArrayBuffer.isView(e)){this.buffer.set((0,i.ensureBuffer)(e),t);this.position=t+e.byteLength>this.position?t+e.length:this.position}else if(typeof e==="string"){this.buffer.write(e,t,e.length,"binary");this.position=t+e.length>this.position?t+e.length:this.position}};e.prototype.read=function(e,t){t=t&&t>0?t:this.position;return this.buffer.slice(e,e+t)};e.prototype.value=function(e){e=!!e;if(e&&this.buffer.length===this.position){return this.buffer}if(e){return this.buffer.slice(0,this.position)}return this.buffer.toString("binary",0,this.position)};e.prototype.length=function(){return this.position};e.prototype.toJSON=function(){return this.buffer.toString("base64")};e.prototype.toString=function(e){return this.buffer.toString(e)};e.prototype.toExtendedJSON=function(e){e=e||{};var t=this.buffer.toString("base64");var r=Number(this.sub_type).toString(16);if(e.legacy){return{$binary:t,$type:r.length===1?"0"+r:r}}return{$binary:{base64:t,subType:r.length===1?"0"+r:r}}};e.prototype.toUUID=function(){if(this.sub_type===e.SUBTYPE_UUID){return new s.UUID(this.buffer.slice(0,this.position))}throw new u.BSONError('Binary sub_type "'.concat(this.sub_type,'" is not supported for converting to UUID. Only "').concat(e.SUBTYPE_UUID,'" is currently supported.'))};e.fromExtendedJSON=function(t,r){r=r||{};var i;var s;if("$binary"in t){if(r.legacy&&typeof t.$binary==="string"&&"$type"in t){s=t.$type?parseInt(t.$type,16):0;i=n.Buffer.from(t.$binary,"base64")}else{if(typeof t.$binary!=="string"){s=t.$binary.subType?parseInt(t.$binary.subType,16):0;i=n.Buffer.from(t.$binary.base64,"base64")}}}else if("$uuid"in t){s=4;i=(0,o.uuidHexStringToBuffer)(t.$uuid)}if(!i){throw new u.BSONTypeError("Unexpected Binary Extended JSON format ".concat(JSON.stringify(t)))}return new e(i,s)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){var e=this.value(true);return'new Binary(Buffer.from("'.concat(e.toString("hex"),'", "hex"), ').concat(this.sub_type,")")};e.BSON_BINARY_SUBTYPE_DEFAULT=0;e.BUFFER_SIZE=256;e.SUBTYPE_DEFAULT=0;e.SUBTYPE_FUNCTION=1;e.SUBTYPE_BYTE_ARRAY=2;e.SUBTYPE_UUID_OLD=3;e.SUBTYPE_UUID=4;e.SUBTYPE_MD5=5;e.SUBTYPE_ENCRYPTED=6;e.SUBTYPE_COLUMN=7;e.SUBTYPE_USER_DEFINED=128;return e}();t.Binary=f;Object.defineProperty(f.prototype,"_bsontype",{value:"Binary"})},"./node_modules/bson/lib/code.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.Code=void 0;var r=function(){function e(t,r){if(!(this instanceof e))return new e(t,r);this.code=t;this.scope=r}e.prototype.toJSON=function(){return{code:this.code,scope:this.scope}};e.prototype.toExtendedJSON=function(){if(this.scope){return{$code:this.code,$scope:this.scope}}return{$code:this.code}};e.fromExtendedJSON=function(t){return new e(t.$code,t.$scope)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){var e=this.toJSON();return'new Code("'.concat(String(e.code),'"').concat(e.scope?", ".concat(JSON.stringify(e.scope)):"",")")};return e}();t.Code=r;Object.defineProperty(r.prototype,"_bsontype",{value:"Code"})},"./node_modules/bson/lib/constants.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.BSON_BINARY_SUBTYPE_USER_DEFINED=t.BSON_BINARY_SUBTYPE_COLUMN=t.BSON_BINARY_SUBTYPE_ENCRYPTED=t.BSON_BINARY_SUBTYPE_MD5=t.BSON_BINARY_SUBTYPE_UUID_NEW=t.BSON_BINARY_SUBTYPE_UUID=t.BSON_BINARY_SUBTYPE_BYTE_ARRAY=t.BSON_BINARY_SUBTYPE_FUNCTION=t.BSON_BINARY_SUBTYPE_DEFAULT=t.BSON_DATA_MAX_KEY=t.BSON_DATA_MIN_KEY=t.BSON_DATA_DECIMAL128=t.BSON_DATA_LONG=t.BSON_DATA_TIMESTAMP=t.BSON_DATA_INT=t.BSON_DATA_CODE_W_SCOPE=t.BSON_DATA_SYMBOL=t.BSON_DATA_CODE=t.BSON_DATA_DBPOINTER=t.BSON_DATA_REGEXP=t.BSON_DATA_NULL=t.BSON_DATA_DATE=t.BSON_DATA_BOOLEAN=t.BSON_DATA_OID=t.BSON_DATA_UNDEFINED=t.BSON_DATA_BINARY=t.BSON_DATA_ARRAY=t.BSON_DATA_OBJECT=t.BSON_DATA_STRING=t.BSON_DATA_NUMBER=t.JS_INT_MIN=t.JS_INT_MAX=t.BSON_INT64_MIN=t.BSON_INT64_MAX=t.BSON_INT32_MIN=t.BSON_INT32_MAX=void 0;t.BSON_INT32_MAX=2147483647;t.BSON_INT32_MIN=-2147483648;t.BSON_INT64_MAX=Math.pow(2,63)-1;t.BSON_INT64_MIN=-Math.pow(2,63);t.JS_INT_MAX=Math.pow(2,53);t.JS_INT_MIN=-Math.pow(2,53);t.BSON_DATA_NUMBER=1;t.BSON_DATA_STRING=2;t.BSON_DATA_OBJECT=3;t.BSON_DATA_ARRAY=4;t.BSON_DATA_BINARY=5;t.BSON_DATA_UNDEFINED=6;t.BSON_DATA_OID=7;t.BSON_DATA_BOOLEAN=8;t.BSON_DATA_DATE=9;t.BSON_DATA_NULL=10;t.BSON_DATA_REGEXP=11;t.BSON_DATA_DBPOINTER=12;t.BSON_DATA_CODE=13;t.BSON_DATA_SYMBOL=14;t.BSON_DATA_CODE_W_SCOPE=15;t.BSON_DATA_INT=16;t.BSON_DATA_TIMESTAMP=17;t.BSON_DATA_LONG=18;t.BSON_DATA_DECIMAL128=19;t.BSON_DATA_MIN_KEY=255;t.BSON_DATA_MAX_KEY=127;t.BSON_BINARY_SUBTYPE_DEFAULT=0;t.BSON_BINARY_SUBTYPE_FUNCTION=1;t.BSON_BINARY_SUBTYPE_BYTE_ARRAY=2;t.BSON_BINARY_SUBTYPE_UUID=3;t.BSON_BINARY_SUBTYPE_UUID_NEW=4;t.BSON_BINARY_SUBTYPE_MD5=5;t.BSON_BINARY_SUBTYPE_ENCRYPTED=6;t.BSON_BINARY_SUBTYPE_COLUMN=7;t.BSON_BINARY_SUBTYPE_USER_DEFINED=128},"./node_modules/bson/lib/db_ref.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.DBRef=t.isDBRefLike=void 0;var n=r("./node_modules/bson/lib/parser/utils.js");function i(e){return(0,n.isObjectLike)(e)&&e.$id!=null&&typeof e.$ref==="string"&&(e.$db==null||typeof e.$db==="string")}t.isDBRefLike=i;var o=function(){function e(t,r,n,i){if(!(this instanceof e))return new e(t,r,n,i);var o=t.split(".");if(o.length===2){n=o.shift();t=o.shift()}this.collection=t;this.oid=r;this.db=n;this.fields=i||{}}Object.defineProperty(e.prototype,"namespace",{get:function(){return this.collection},set:function(e){this.collection=e},enumerable:false,configurable:true});e.prototype.toJSON=function(){var e=Object.assign({$ref:this.collection,$id:this.oid},this.fields);if(this.db!=null)e.$db=this.db;return e};e.prototype.toExtendedJSON=function(e){e=e||{};var t={$ref:this.collection,$id:this.oid};if(e.legacy){return t}if(this.db)t.$db=this.db;t=Object.assign(t,this.fields);return t};e.fromExtendedJSON=function(t){var r=Object.assign({},t);delete r.$ref;delete r.$id;delete r.$db;return new e(t.$ref,t.$id,t.$db,r)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){var e=this.oid===undefined||this.oid.toString===undefined?this.oid:this.oid.toString();return'new DBRef("'.concat(this.namespace,'", new ObjectId("').concat(String(e),'")').concat(this.db?', "'.concat(this.db,'"'):"",")")};return e}();t.DBRef=o;Object.defineProperty(o.prototype,"_bsontype",{value:"DBRef"})},"./node_modules/bson/lib/decimal128.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.Decimal128=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/error.js");var o=r("./node_modules/bson/lib/long.js");var s=r("./node_modules/bson/lib/parser/utils.js");var u=/^(\+|-)?(\d+|(\d*\.\d*))?(E|e)?([-+])?(\d+)?$/;var f=/^(\+|-)?(Infinity|inf)$/i;var a=/^(\+|-)?NaN$/i;var l=6111;var c=-6176;var d=6176;var p=34;var b=[124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0].reverse();var h=[248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0].reverse();var _=[120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0].reverse();var y=/^([-+])?(\d+)?$/;var g=31;var v=16383;var B=30;var O=31;function m(e){return!isNaN(parseInt(e,10))}function N(e){var t=o.Long.fromNumber(1e3*1e3*1e3);var r=o.Long.fromNumber(0);if(!e.parts[0]&&!e.parts[1]&&!e.parts[2]&&!e.parts[3]){return{quotient:e,rem:r}}for(var n=0;n<=3;n++){r=r.shiftLeft(32);r=r.add(new o.Long(e.parts[n],0));e.parts[n]=r.div(t).low;r=r.modulo(t)}return{quotient:e,rem:r}}function S(e,t){if(!e&&!t){return{high:o.Long.fromNumber(0),low:o.Long.fromNumber(0)}}var r=e.shiftRightUnsigned(32);var n=new o.Long(e.getLowBits(),0);var i=t.shiftRightUnsigned(32);var s=new o.Long(t.getLowBits(),0);var u=r.multiply(i);var f=r.multiply(s);var a=n.multiply(i);var l=n.multiply(s);u=u.add(f.shiftRightUnsigned(32));f=new o.Long(f.getLowBits(),0).add(a).add(l.shiftRightUnsigned(32));u=u.add(f.shiftRightUnsigned(32));l=f.shiftLeft(32).add(new o.Long(l.getLowBits(),0));return{high:u,low:l}}function A(e,t){var r=e.high>>>0;var n=t.high>>>0;if(r<n){return true}else if(r===n){var i=e.low>>>0;var o=t.low>>>0;if(i<o)return true}return false}function E(e,t){throw new i.BSONTypeError('"'.concat(e,'" is not a valid Decimal128 string - ').concat(t))}var w=function(){function e(t){if(!(this instanceof e))return new e(t);if(typeof t==="string"){this.bytes=e.fromString(t).bytes}else if((0,s.isUint8Array)(t)){if(t.byteLength!==16){throw new i.BSONTypeError("Decimal128 must take a Buffer of 16 bytes")}this.bytes=t}else{throw new i.BSONTypeError("Decimal128 must take a Buffer or string")}}e.fromString=function(t){var r=false;var s=false;var g=false;var v=0;var B=0;var O=0;var N=0;var w=0;var T=[0];var j=0;var D=0;var I=0;var x=0;var U=0;var L=0;var R=new o.Long(0,0);var P=new o.Long(0,0);var M=0;var Y=0;if(t.length>=7e3){throw new i.BSONTypeError(""+t+" not a valid Decimal128 string")}var $=t.match(u);var C=t.match(f);var J=t.match(a);if(!$&&!C&&!J||t.length===0){throw new i.BSONTypeError(""+t+" not a valid Decimal128 string")}if($){var z=$[2];var F=$[4];var k=$[5];var K=$[6];if(F&&K===undefined)E(t,"missing exponent power");if(F&&z===undefined)E(t,"missing exponent base");if(F===undefined&&(k||K)){E(t,"missing e before exponent")}}if(t[Y]==="+"||t[Y]==="-"){r=t[Y++]==="-"}if(!m(t[Y])&&t[Y]!=="."){if(t[Y]==="i"||t[Y]==="I"){return new e(n.Buffer.from(r?h:_))}else if(t[Y]==="N"){return new e(n.Buffer.from(b))}}while(m(t[Y])||t[Y]==="."){if(t[Y]==="."){if(s)E(t,"contains multiple periods");s=true;Y=Y+1;continue}if(j<34){if(t[Y]!=="0"||g){if(!g){w=B}g=true;T[D++]=parseInt(t[Y],10);j=j+1}}if(g)O=O+1;if(s)N=N+1;B=B+1;Y=Y+1}if(s&&!B)throw new i.BSONTypeError(""+t+" not a valid Decimal128 string");if(t[Y]==="e"||t[Y]==="E"){var V=t.substr(++Y).match(y);if(!V||!V[2])return new e(n.Buffer.from(b));U=parseInt(V[0],10);Y=Y+V[0].length}if(t[Y])return new e(n.Buffer.from(b));I=0;if(!j){I=0;x=0;T[0]=0;O=1;j=1;v=0}else{x=j-1;v=O;if(v!==1){while(T[w+v-1]===0){v=v-1}}}if(U<=N&&N-U>1<<14){U=c}else{U=U-N}while(U>l){x=x+1;if(x-I>p){var q=T.join("");if(q.match(/^0+$/)){U=l;break}E(t,"overflow")}U=U-1}while(U<c||j<O){if(x===0&&v<j){U=c;v=0;break}if(j<O){O=O-1}else{x=x-1}if(U<l){U=U+1}else{var q=T.join("");if(q.match(/^0+$/)){U=l;break}E(t,"overflow")}}if(x-I+1<v){var H=B;if(s){w=w+1;H=H+1}if(r){w=w+1;H=H+1}var X=parseInt(t[w+x+1],10);var G=0;if(X>=5){G=1;if(X===5){G=T[x]%2===1?1:0;for(L=w+x+2;L<H;L++){if(parseInt(t[L],10)){G=1;break}}}}if(G){var Z=x;for(;Z>=0;Z--){if(++T[Z]>9){T[Z]=0;if(Z===0){if(U<l){U=U+1;T[Z]=1}else{return new e(n.Buffer.from(r?h:_))}}}}}}R=o.Long.fromNumber(0);P=o.Long.fromNumber(0);if(v===0){R=o.Long.fromNumber(0);P=o.Long.fromNumber(0)}else if(x-I<17){var Z=I;P=o.Long.fromNumber(T[Z++]);R=new o.Long(0,0);for(;Z<=x;Z++){P=P.multiply(o.Long.fromNumber(10));P=P.add(o.Long.fromNumber(T[Z]))}}else{var Z=I;R=o.Long.fromNumber(T[Z++]);for(;Z<=x-17;Z++){R=R.multiply(o.Long.fromNumber(10));R=R.add(o.Long.fromNumber(T[Z]))}P=o.Long.fromNumber(T[Z++]);for(;Z<=x;Z++){P=P.multiply(o.Long.fromNumber(10));P=P.add(o.Long.fromNumber(T[Z]))}}var W=S(R,o.Long.fromString("100000000000000000"));W.low=W.low.add(P);if(A(W.low,P)){W.high=W.high.add(o.Long.fromNumber(1))}M=U+d;var Q={low:o.Long.fromNumber(0),high:o.Long.fromNumber(0)};if(W.high.shiftRightUnsigned(49).and(o.Long.fromNumber(1)).equals(o.Long.fromNumber(1))){Q.high=Q.high.or(o.Long.fromNumber(3).shiftLeft(61));Q.high=Q.high.or(o.Long.fromNumber(M).and(o.Long.fromNumber(16383).shiftLeft(47)));Q.high=Q.high.or(W.high.and(o.Long.fromNumber(0x7fffffffffff)))}else{Q.high=Q.high.or(o.Long.fromNumber(M&16383).shiftLeft(49));Q.high=Q.high.or(W.high.and(o.Long.fromNumber(562949953421311)))}Q.low=W.low;if(r){Q.high=Q.high.or(o.Long.fromString("9223372036854775808"))}var ee=n.Buffer.alloc(16);Y=0;ee[Y++]=Q.low.low&255;ee[Y++]=Q.low.low>>8&255;ee[Y++]=Q.low.low>>16&255;ee[Y++]=Q.low.low>>24&255;ee[Y++]=Q.low.high&255;ee[Y++]=Q.low.high>>8&255;ee[Y++]=Q.low.high>>16&255;ee[Y++]=Q.low.high>>24&255;ee[Y++]=Q.high.low&255;ee[Y++]=Q.high.low>>8&255;ee[Y++]=Q.high.low>>16&255;ee[Y++]=Q.high.low>>24&255;ee[Y++]=Q.high.high&255;ee[Y++]=Q.high.high>>8&255;ee[Y++]=Q.high.high>>16&255;ee[Y++]=Q.high.high>>24&255;return new e(ee)};e.prototype.toString=function(){var e;var t=0;var r=new Array(36);for(var n=0;n<r.length;n++)r[n]=0;var i=0;var s=false;var u;var f={parts:[0,0,0,0]};var a,l;var c=[];i=0;var p=this.bytes;var b=p[i++]|p[i++]<<8|p[i++]<<16|p[i++]<<24;var h=p[i++]|p[i++]<<8|p[i++]<<16|p[i++]<<24;var _=p[i++]|p[i++]<<8|p[i++]<<16|p[i++]<<24;var y=p[i++]|p[i++]<<8|p[i++]<<16|p[i++]<<24;i=0;var m={low:new o.Long(b,h),high:new o.Long(_,y)};if(m.high.lessThan(o.Long.ZERO)){c.push("-")}var S=y>>26&g;if(S>>3===3){if(S===B){return c.join("")+"Infinity"}else if(S===O){return"NaN"}else{e=y>>15&v;u=8+(y>>14&1)}}else{u=y>>14&7;e=y>>17&v}var A=e-d;f.parts[0]=(y&16383)+((u&15)<<14);f.parts[1]=_;f.parts[2]=h;f.parts[3]=b;if(f.parts[0]===0&&f.parts[1]===0&&f.parts[2]===0&&f.parts[3]===0){s=true}else{for(l=3;l>=0;l--){var E=0;var w=N(f);f=w.quotient;E=w.rem.low;if(!E)continue;for(a=8;a>=0;a--){r[l*9+a]=E%10;E=Math.floor(E/10)}}}if(s){t=1;r[i]=0}else{t=36;while(!r[i]){t=t-1;i=i+1}}var T=t-1+A;if(T>=34||T<=-7||A>0){if(t>34){c.push("".concat(0));if(A>0)c.push("E+".concat(A));else if(A<0)c.push("E".concat(A));return c.join("")}c.push("".concat(r[i++]));t=t-1;if(t){c.push(".")}for(var n=0;n<t;n++){c.push("".concat(r[i++]))}c.push("E");if(T>0){c.push("+".concat(T))}else{c.push("".concat(T))}}else{if(A>=0){for(var n=0;n<t;n++){c.push("".concat(r[i++]))}}else{var j=t+A;if(j>0){for(var n=0;n<j;n++){c.push("".concat(r[i++]))}}else{c.push("0")}c.push(".");while(j++<0){c.push("0")}for(var n=0;n<t-Math.max(j-1,0);n++){c.push("".concat(r[i++]))}}}return c.join("")};e.prototype.toJSON=function(){return{$numberDecimal:this.toString()}};e.prototype.toExtendedJSON=function(){return{$numberDecimal:this.toString()}};e.fromExtendedJSON=function(t){return e.fromString(t.$numberDecimal)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){return'new Decimal128("'.concat(this.toString(),'")')};return e}();t.Decimal128=w;Object.defineProperty(w.prototype,"_bsontype",{value:"Decimal128"})},"./node_modules/bson/lib/double.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.Double=void 0;var r=function(){function e(t){if(!(this instanceof e))return new e(t);if(t instanceof Number){t=t.valueOf()}this.value=+t}e.prototype.valueOf=function(){return this.value};e.prototype.toJSON=function(){return this.value};e.prototype.toString=function(e){return this.value.toString(e)};e.prototype.toExtendedJSON=function(e){if(e&&(e.legacy||e.relaxed&&isFinite(this.value))){return this.value}if(Object.is(Math.sign(this.value),-0)){return{$numberDouble:"-".concat(this.value.toFixed(1))}}var t;if(Number.isInteger(this.value)){t=this.value.toFixed(1);if(t.length>=13){t=this.value.toExponential(13).toUpperCase()}}else{t=this.value.toString()}return{$numberDouble:t}};e.fromExtendedJSON=function(t,r){var n=parseFloat(t.$numberDouble);return r&&r.relaxed?n:new e(n)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){var e=this.toExtendedJSON();return"new Double(".concat(e.$numberDouble,")")};return e}();t.Double=r;Object.defineProperty(r.prototype,"_bsontype",{value:"Double"})},"./node_modules/bson/lib/ensure_buffer.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.ensureBuffer=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/error.js");var o=r("./node_modules/bson/lib/parser/utils.js");function s(e){if(ArrayBuffer.isView(e)){return n.Buffer.from(e.buffer,e.byteOffset,e.byteLength)}if((0,o.isAnyArrayBuffer)(e)){return n.Buffer.from(e)}throw new i.BSONTypeError("Must use either Buffer or TypedArray")}t.ensureBuffer=s},"./node_modules/bson/lib/error.js":function(e,t){var r=this&&this.__extends||function(){var e=function(t,r){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)if(Object.prototype.hasOwnProperty.call(t,r))e[r]=t[r]};return e(t,r)};return function(t,r){if(typeof r!=="function"&&r!==null)throw new TypeError("Class extends value "+String(r)+" is not a constructor or null");e(t,r);function n(){this.constructor=t}t.prototype=r===null?Object.create(r):(n.prototype=r.prototype,new n)}}();Object.defineProperty(t,"__esModule",{value:true});t.BSONTypeError=t.BSONError=void 0;var n=function(e){r(t,e);function t(r){var n=e.call(this,r)||this;Object.setPrototypeOf(n,t.prototype);return n}Object.defineProperty(t.prototype,"name",{get:function(){return"BSONError"},enumerable:false,configurable:true});return t}(Error);t.BSONError=n;var i=function(e){r(t,e);function t(r){var n=e.call(this,r)||this;Object.setPrototypeOf(n,t.prototype);return n}Object.defineProperty(t.prototype,"name",{get:function(){return"BSONTypeError"},enumerable:false,configurable:true});return t}(TypeError);t.BSONTypeError=i},"./node_modules/bson/lib/extended_json.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.EJSON=t.isBSONType=void 0;var n=r("./node_modules/bson/lib/binary.js");var i=r("./node_modules/bson/lib/code.js");var o=r("./node_modules/bson/lib/db_ref.js");var s=r("./node_modules/bson/lib/decimal128.js");var u=r("./node_modules/bson/lib/double.js");var f=r("./node_modules/bson/lib/error.js");var a=r("./node_modules/bson/lib/int_32.js");var l=r("./node_modules/bson/lib/long.js");var c=r("./node_modules/bson/lib/max_key.js");var d=r("./node_modules/bson/lib/min_key.js");var p=r("./node_modules/bson/lib/objectid.js");var b=r("./node_modules/bson/lib/parser/utils.js");var h=r("./node_modules/bson/lib/regexp.js");var _=r("./node_modules/bson/lib/symbol.js");var y=r("./node_modules/bson/lib/timestamp.js");function g(e){return(0,b.isObjectLike)(e)&&Reflect.has(e,"_bsontype")&&typeof e._bsontype==="string"}t.isBSONType=g;var v=2147483647;var B=-2147483648;var O=0x8000000000000000;var m=-0x8000000000000000;var N={$oid:p.ObjectId,$binary:n.Binary,$uuid:n.Binary,$symbol:_.BSONSymbol,$numberInt:a.Int32,$numberDecimal:s.Decimal128,$numberDouble:u.Double,$numberLong:l.Long,$minKey:d.MinKey,$maxKey:c.MaxKey,$regex:h.BSONRegExp,$regularExpression:h.BSONRegExp,$timestamp:y.Timestamp};function S(e,t){if(t===void 0){t={}}if(typeof e==="number"){if(t.relaxed||t.legacy){return e}if(Math.floor(e)===e){if(e>=B&&e<=v)return new a.Int32(e);if(e>=m&&e<=O)return l.Long.fromNumber(e)}return new u.Double(e)}if(e==null||typeof e!=="object")return e;if(e.$undefined)return null;var r=Object.keys(e).filter((function(t){return t.startsWith("$")&&e[t]!=null}));for(var n=0;n<r.length;n++){var s=N[r[n]];if(s)return s.fromExtendedJSON(e,t)}if(e.$date!=null){var f=e.$date;var c=new Date;if(t.legacy){if(typeof f==="number")c.setTime(f);else if(typeof f==="string")c.setTime(Date.parse(f))}else{if(typeof f==="string")c.setTime(Date.parse(f));else if(l.Long.isLong(f))c.setTime(f.toNumber());else if(typeof f==="number"&&t.relaxed)c.setTime(f)}return c}if(e.$code!=null){var d=Object.assign({},e);if(e.$scope){d.$scope=S(e.$scope)}return i.Code.fromExtendedJSON(e)}if((0,o.isDBRefLike)(e)||e.$dbPointer){var p=e.$ref?e:e.$dbPointer;if(p instanceof o.DBRef)return p;var b=Object.keys(p).filter((function(e){return e.startsWith("$")}));var h=true;b.forEach((function(e){if(["$ref","$id","$db"].indexOf(e)===-1)h=false}));if(h)return o.DBRef.fromExtendedJSON(p)}return e}function A(e,t){return e.map((function(e,r){t.seenObjects.push({propertyName:"index ".concat(r),obj:null});try{return w(e,t)}finally{t.seenObjects.pop()}}))}function E(e){var t=e.toISOString();return e.getUTCMilliseconds()!==0?t:t.slice(0,-5)+"Z"}function w(e,t){if((typeof e==="object"||typeof e==="function")&&e!==null){var r=t.seenObjects.findIndex((function(t){return t.obj===e}));if(r!==-1){var n=t.seenObjects.map((function(e){return e.propertyName}));var i=n.slice(0,r).map((function(e){return"".concat(e," -> ")})).join("");var o=n[r];var s=" -> "+n.slice(r+1,n.length-1).map((function(e){return"".concat(e," -> ")})).join("");var u=n[n.length-1];var a=" ".repeat(i.length+o.length/2);var l="-".repeat(s.length+(o.length+u.length)/2-1);throw new f.BSONTypeError("Converting circular structure to EJSON:\n"+"    ".concat(i).concat(o).concat(s).concat(u,"\n")+"    ".concat(a,"\\").concat(l,"/"))}t.seenObjects[t.seenObjects.length-1].obj=e}if(Array.isArray(e))return A(e,t);if(e===undefined)return null;if(e instanceof Date||(0,b.isDate)(e)){var c=e.getTime(),d=c>-1&&c<2534023188e5;if(t.legacy){return t.relaxed&&d?{$date:e.getTime()}:{$date:E(e)}}return t.relaxed&&d?{$date:E(e)}:{$date:{$numberLong:e.getTime().toString()}}}if(typeof e==="number"&&(!t.relaxed||!isFinite(e))){if(Math.floor(e)===e){var p=e>=B&&e<=v,_=e>=m&&e<=O;if(p)return{$numberInt:e.toString()};if(_)return{$numberLong:e.toString()}}return{$numberDouble:e.toString()}}if(e instanceof RegExp||(0,b.isRegExp)(e)){var y=e.flags;if(y===undefined){var g=e.toString().match(/[gimuy]*$/);if(g){y=g[0]}}var N=new h.BSONRegExp(e.source,y);return N.toExtendedJSON(t)}if(e!=null&&typeof e==="object")return j(e,t);return e}var T={Binary:function(e){return new n.Binary(e.value(),e.sub_type)},Code:function(e){return new i.Code(e.code,e.scope)},DBRef:function(e){return new o.DBRef(e.collection||e.namespace,e.oid,e.db,e.fields)},Decimal128:function(e){return new s.Decimal128(e.bytes)},Double:function(e){return new u.Double(e.value)},Int32:function(e){return new a.Int32(e.value)},Long:function(e){return l.Long.fromBits(e.low!=null?e.low:e.low_,e.low!=null?e.high:e.high_,e.low!=null?e.unsigned:e.unsigned_)},MaxKey:function(){return new c.MaxKey},MinKey:function(){return new d.MinKey},ObjectID:function(e){return new p.ObjectId(e)},ObjectId:function(e){return new p.ObjectId(e)},BSONRegExp:function(e){return new h.BSONRegExp(e.pattern,e.options)},Symbol:function(e){return new _.BSONSymbol(e.value)},Timestamp:function(e){return y.Timestamp.fromBits(e.low,e.high)}};function j(e,t){if(e==null||typeof e!=="object")throw new f.BSONError("not an object instance");var r=e._bsontype;if(typeof r==="undefined"){var n={};for(var s in e){t.seenObjects.push({propertyName:s,obj:null});try{var u=w(e[s],t);if(s==="__proto__"){Object.defineProperty(n,s,{value:u,writable:true,enumerable:true,configurable:true})}else{n[s]=u}}finally{t.seenObjects.pop()}}return n}else if(g(e)){var a=e;if(typeof a.toExtendedJSON!=="function"){var l=T[e._bsontype];if(!l){throw new f.BSONTypeError("Unrecognized or invalid _bsontype: "+e._bsontype)}a=l(a)}if(r==="Code"&&a.scope){a=new i.Code(a.code,w(a.scope,t))}else if(r==="DBRef"&&a.oid){a=new o.DBRef(w(a.collection,t),w(a.oid,t),w(a.db,t),w(a.fields,t))}return a.toExtendedJSON(t)}else{throw new f.BSONError("_bsontype must be a string, but was: "+typeof r)}}var D;(function(e){function t(e,t){var r=Object.assign({},{relaxed:true,legacy:false},t);if(typeof r.relaxed==="boolean")r.strict=!r.relaxed;if(typeof r.strict==="boolean")r.relaxed=!r.strict;return JSON.parse(e,(function(e,t){if(e.indexOf("\0")!==-1){throw new f.BSONError("BSON Document field names cannot contain null bytes, found: ".concat(JSON.stringify(e)))}return S(t,r)}))}e.parse=t;function r(e,t,r,n){if(r!=null&&typeof r==="object"){n=r;r=0}if(t!=null&&typeof t==="object"&&!Array.isArray(t)){n=t;t=undefined;r=0}var i=Object.assign({relaxed:true,legacy:false},n,{seenObjects:[{propertyName:"(root)",obj:null}]});var o=w(e,i);return JSON.stringify(o,t,r)}e.stringify=r;function n(e,t){t=t||{};return JSON.parse(r(e,t))}e.serialize=n;function i(e,r){r=r||{};return t(JSON.stringify(e),r)}e.deserialize=i})(D=t.EJSON||(t.EJSON={}))},"./node_modules/bson/lib/int_32.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.Int32=void 0;var r=function(){function e(t){if(!(this instanceof e))return new e(t);if(t instanceof Number){t=t.valueOf()}this.value=+t|0}e.prototype.valueOf=function(){return this.value};e.prototype.toString=function(e){return this.value.toString(e)};e.prototype.toJSON=function(){return this.value};e.prototype.toExtendedJSON=function(e){if(e&&(e.relaxed||e.legacy))return this.value;return{$numberInt:this.value.toString()}};e.fromExtendedJSON=function(t,r){return r&&r.relaxed?parseInt(t.$numberInt,10):new e(t.$numberInt)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){return"new Int32(".concat(this.valueOf(),")")};return e}();t.Int32=r;Object.defineProperty(r.prototype,"_bsontype",{value:"Int32"})},"./node_modules/bson/lib/long.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.Long=void 0;var n=r("./node_modules/bson/lib/parser/utils.js");var i=undefined;try{i=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}var o=1<<16;var s=1<<24;var u=o*o;var f=u*u;var a=f/2;var l={};var c={};var d=function(){function e(t,r,n){if(t===void 0){t=0}if(!(this instanceof e))return new e(t,r,n);if(typeof t==="bigint"){Object.assign(this,e.fromBigInt(t,!!r))}else if(typeof t==="string"){Object.assign(this,e.fromString(t,!!r))}else{this.low=t|0;this.high=r|0;this.unsigned=!!n}Object.defineProperty(this,"__isLong__",{value:true,configurable:false,writable:false,enumerable:false})}e.fromBits=function(t,r,n){return new e(t,r,n)};e.fromInt=function(t,r){var n,i,o;if(r){t>>>=0;if(o=0<=t&&t<256){i=c[t];if(i)return i}n=e.fromBits(t,(t|0)<0?-1:0,true);if(o)c[t]=n;return n}else{t|=0;if(o=-128<=t&&t<128){i=l[t];if(i)return i}n=e.fromBits(t,t<0?-1:0,false);if(o)l[t]=n;return n}};e.fromNumber=function(t,r){if(isNaN(t))return r?e.UZERO:e.ZERO;if(r){if(t<0)return e.UZERO;if(t>=f)return e.MAX_UNSIGNED_VALUE}else{if(t<=-a)return e.MIN_VALUE;if(t+1>=a)return e.MAX_VALUE}if(t<0)return e.fromNumber(-t,r).neg();return e.fromBits(t%u|0,t/u|0,r)};e.fromBigInt=function(t,r){return e.fromString(t.toString(),r)};e.fromString=function(t,r,n){if(t.length===0)throw Error("empty string");if(t==="NaN"||t==="Infinity"||t==="+Infinity"||t==="-Infinity")return e.ZERO;if(typeof r==="number"){n=r,r=false}else{r=!!r}n=n||10;if(n<2||36<n)throw RangeError("radix");var i;if((i=t.indexOf("-"))>0)throw Error("interior hyphen");else if(i===0){return e.fromString(t.substring(1),r,n).neg()}var o=e.fromNumber(Math.pow(n,8));var s=e.ZERO;for(var u=0;u<t.length;u+=8){var f=Math.min(8,t.length-u),a=parseInt(t.substring(u,u+f),n);if(f<8){var l=e.fromNumber(Math.pow(n,f));s=s.mul(l).add(e.fromNumber(a))}else{s=s.mul(o);s=s.add(e.fromNumber(a))}}s.unsigned=r;return s};e.fromBytes=function(t,r,n){return n?e.fromBytesLE(t,r):e.fromBytesBE(t,r)};e.fromBytesLE=function(t,r){return new e(t[0]|t[1]<<8|t[2]<<16|t[3]<<24,t[4]|t[5]<<8|t[6]<<16|t[7]<<24,r)};e.fromBytesBE=function(t,r){return new e(t[4]<<24|t[5]<<16|t[6]<<8|t[7],t[0]<<24|t[1]<<16|t[2]<<8|t[3],r)};e.isLong=function(e){return(0,n.isObjectLike)(e)&&e["__isLong__"]===true};e.fromValue=function(t,r){if(typeof t==="number")return e.fromNumber(t,r);if(typeof t==="string")return e.fromString(t,r);return e.fromBits(t.low,t.high,typeof r==="boolean"?r:t.unsigned)};e.prototype.add=function(t){if(!e.isLong(t))t=e.fromValue(t);var r=this.high>>>16;var n=this.high&65535;var i=this.low>>>16;var o=this.low&65535;var s=t.high>>>16;var u=t.high&65535;var f=t.low>>>16;var a=t.low&65535;var l=0,c=0,d=0,p=0;p+=o+a;d+=p>>>16;p&=65535;d+=i+f;c+=d>>>16;d&=65535;c+=n+u;l+=c>>>16;c&=65535;l+=r+s;l&=65535;return e.fromBits(d<<16|p,l<<16|c,this.unsigned)};e.prototype.and=function(t){if(!e.isLong(t))t=e.fromValue(t);return e.fromBits(this.low&t.low,this.high&t.high,this.unsigned)};e.prototype.compare=function(t){if(!e.isLong(t))t=e.fromValue(t);if(this.eq(t))return 0;var r=this.isNegative(),n=t.isNegative();if(r&&!n)return-1;if(!r&&n)return 1;if(!this.unsigned)return this.sub(t).isNegative()?-1:1;return t.high>>>0>this.high>>>0||t.high===this.high&&t.low>>>0>this.low>>>0?-1:1};e.prototype.comp=function(e){return this.compare(e)};e.prototype.divide=function(t){if(!e.isLong(t))t=e.fromValue(t);if(t.isZero())throw Error("division by zero");if(i){if(!this.unsigned&&this.high===-2147483648&&t.low===-1&&t.high===-1){return this}var r=(this.unsigned?i.div_u:i.div_s)(this.low,this.high,t.low,t.high);return e.fromBits(r,i.get_high(),this.unsigned)}if(this.isZero())return this.unsigned?e.UZERO:e.ZERO;var n,o,s;if(!this.unsigned){if(this.eq(e.MIN_VALUE)){if(t.eq(e.ONE)||t.eq(e.NEG_ONE))return e.MIN_VALUE;else if(t.eq(e.MIN_VALUE))return e.ONE;else{var u=this.shr(1);n=u.div(t).shl(1);if(n.eq(e.ZERO)){return t.isNegative()?e.ONE:e.NEG_ONE}else{o=this.sub(t.mul(n));s=n.add(o.div(t));return s}}}else if(t.eq(e.MIN_VALUE))return this.unsigned?e.UZERO:e.ZERO;if(this.isNegative()){if(t.isNegative())return this.neg().div(t.neg());return this.neg().div(t).neg()}else if(t.isNegative())return this.div(t.neg()).neg();s=e.ZERO}else{if(!t.unsigned)t=t.toUnsigned();if(t.gt(this))return e.UZERO;if(t.gt(this.shru(1)))return e.UONE;s=e.UZERO}o=this;while(o.gte(t)){n=Math.max(1,Math.floor(o.toNumber()/t.toNumber()));var f=Math.ceil(Math.log(n)/Math.LN2);var a=f<=48?1:Math.pow(2,f-48);var l=e.fromNumber(n);var c=l.mul(t);while(c.isNegative()||c.gt(o)){n-=a;l=e.fromNumber(n,this.unsigned);c=l.mul(t)}if(l.isZero())l=e.ONE;s=s.add(l);o=o.sub(c)}return s};e.prototype.div=function(e){return this.divide(e)};e.prototype.equals=function(t){if(!e.isLong(t))t=e.fromValue(t);if(this.unsigned!==t.unsigned&&this.high>>>31===1&&t.high>>>31===1)return false;return this.high===t.high&&this.low===t.low};e.prototype.eq=function(e){return this.equals(e)};e.prototype.getHighBits=function(){return this.high};e.prototype.getHighBitsUnsigned=function(){return this.high>>>0};e.prototype.getLowBits=function(){return this.low};e.prototype.getLowBitsUnsigned=function(){return this.low>>>0};e.prototype.getNumBitsAbs=function(){if(this.isNegative()){return this.eq(e.MIN_VALUE)?64:this.neg().getNumBitsAbs()}var t=this.high!==0?this.high:this.low;var r;for(r=31;r>0;r--)if((t&1<<r)!==0)break;return this.high!==0?r+33:r+1};e.prototype.greaterThan=function(e){return this.comp(e)>0};e.prototype.gt=function(e){return this.greaterThan(e)};e.prototype.greaterThanOrEqual=function(e){return this.comp(e)>=0};e.prototype.gte=function(e){return this.greaterThanOrEqual(e)};e.prototype.ge=function(e){return this.greaterThanOrEqual(e)};e.prototype.isEven=function(){return(this.low&1)===0};e.prototype.isNegative=function(){return!this.unsigned&&this.high<0};e.prototype.isOdd=function(){return(this.low&1)===1};e.prototype.isPositive=function(){return this.unsigned||this.high>=0};e.prototype.isZero=function(){return this.high===0&&this.low===0};e.prototype.lessThan=function(e){return this.comp(e)<0};e.prototype.lt=function(e){return this.lessThan(e)};e.prototype.lessThanOrEqual=function(e){return this.comp(e)<=0};e.prototype.lte=function(e){return this.lessThanOrEqual(e)};e.prototype.modulo=function(t){if(!e.isLong(t))t=e.fromValue(t);if(i){var r=(this.unsigned?i.rem_u:i.rem_s)(this.low,this.high,t.low,t.high);return e.fromBits(r,i.get_high(),this.unsigned)}return this.sub(this.div(t).mul(t))};e.prototype.mod=function(e){return this.modulo(e)};e.prototype.rem=function(e){return this.modulo(e)};e.prototype.multiply=function(t){if(this.isZero())return e.ZERO;if(!e.isLong(t))t=e.fromValue(t);if(i){var r=i.mul(this.low,this.high,t.low,t.high);return e.fromBits(r,i.get_high(),this.unsigned)}if(t.isZero())return e.ZERO;if(this.eq(e.MIN_VALUE))return t.isOdd()?e.MIN_VALUE:e.ZERO;if(t.eq(e.MIN_VALUE))return this.isOdd()?e.MIN_VALUE:e.ZERO;if(this.isNegative()){if(t.isNegative())return this.neg().mul(t.neg());else return this.neg().mul(t).neg()}else if(t.isNegative())return this.mul(t.neg()).neg();if(this.lt(e.TWO_PWR_24)&&t.lt(e.TWO_PWR_24))return e.fromNumber(this.toNumber()*t.toNumber(),this.unsigned);var n=this.high>>>16;var o=this.high&65535;var s=this.low>>>16;var u=this.low&65535;var f=t.high>>>16;var a=t.high&65535;var l=t.low>>>16;var c=t.low&65535;var d=0,p=0,b=0,h=0;h+=u*c;b+=h>>>16;h&=65535;b+=s*c;p+=b>>>16;b&=65535;b+=u*l;p+=b>>>16;b&=65535;p+=o*c;d+=p>>>16;p&=65535;p+=s*l;d+=p>>>16;p&=65535;p+=u*a;d+=p>>>16;p&=65535;d+=n*c+o*l+s*a+u*f;d&=65535;return e.fromBits(b<<16|h,d<<16|p,this.unsigned)};e.prototype.mul=function(e){return this.multiply(e)};e.prototype.negate=function(){if(!this.unsigned&&this.eq(e.MIN_VALUE))return e.MIN_VALUE;return this.not().add(e.ONE)};e.prototype.neg=function(){return this.negate()};e.prototype.not=function(){return e.fromBits(~this.low,~this.high,this.unsigned)};e.prototype.notEquals=function(e){return!this.equals(e)};e.prototype.neq=function(e){return this.notEquals(e)};e.prototype.ne=function(e){return this.notEquals(e)};e.prototype.or=function(t){if(!e.isLong(t))t=e.fromValue(t);return e.fromBits(this.low|t.low,this.high|t.high,this.unsigned)};e.prototype.shiftLeft=function(t){if(e.isLong(t))t=t.toInt();if((t&=63)===0)return this;else if(t<32)return e.fromBits(this.low<<t,this.high<<t|this.low>>>32-t,this.unsigned);else return e.fromBits(0,this.low<<t-32,this.unsigned)};e.prototype.shl=function(e){return this.shiftLeft(e)};e.prototype.shiftRight=function(t){if(e.isLong(t))t=t.toInt();if((t&=63)===0)return this;else if(t<32)return e.fromBits(this.low>>>t|this.high<<32-t,this.high>>t,this.unsigned);else return e.fromBits(this.high>>t-32,this.high>=0?0:-1,this.unsigned)};e.prototype.shr=function(e){return this.shiftRight(e)};e.prototype.shiftRightUnsigned=function(t){if(e.isLong(t))t=t.toInt();t&=63;if(t===0)return this;else{var r=this.high;if(t<32){var n=this.low;return e.fromBits(n>>>t|r<<32-t,r>>>t,this.unsigned)}else if(t===32)return e.fromBits(r,0,this.unsigned);else return e.fromBits(r>>>t-32,0,this.unsigned)}};e.prototype.shr_u=function(e){return this.shiftRightUnsigned(e)};e.prototype.shru=function(e){return this.shiftRightUnsigned(e)};e.prototype.subtract=function(t){if(!e.isLong(t))t=e.fromValue(t);return this.add(t.neg())};e.prototype.sub=function(e){return this.subtract(e)};e.prototype.toInt=function(){return this.unsigned?this.low>>>0:this.low};e.prototype.toNumber=function(){if(this.unsigned)return(this.high>>>0)*u+(this.low>>>0);return this.high*u+(this.low>>>0)};e.prototype.toBigInt=function(){return BigInt(this.toString())};e.prototype.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()};e.prototype.toBytesLE=function(){var e=this.high,t=this.low;return[t&255,t>>>8&255,t>>>16&255,t>>>24,e&255,e>>>8&255,e>>>16&255,e>>>24]};e.prototype.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,e&255,t>>>24,t>>>16&255,t>>>8&255,t&255]};e.prototype.toSigned=function(){if(!this.unsigned)return this;return e.fromBits(this.low,this.high,false)};e.prototype.toString=function(t){t=t||10;if(t<2||36<t)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(e.MIN_VALUE)){var r=e.fromNumber(t),n=this.div(r),i=n.mul(r).sub(this);return n.toString(t)+i.toInt().toString(t)}else return"-"+this.neg().toString(t)}var o=e.fromNumber(Math.pow(t,6),this.unsigned);var s=this;var u="";while(true){var f=s.div(o);var a=s.sub(f.mul(o)).toInt()>>>0;var l=a.toString(t);s=f;if(s.isZero()){return l+u}else{while(l.length<6)l="0"+l;u=""+l+u}}};e.prototype.toUnsigned=function(){if(this.unsigned)return this;return e.fromBits(this.low,this.high,true)};e.prototype.xor=function(t){if(!e.isLong(t))t=e.fromValue(t);return e.fromBits(this.low^t.low,this.high^t.high,this.unsigned)};e.prototype.eqz=function(){return this.isZero()};e.prototype.le=function(e){return this.lessThanOrEqual(e)};e.prototype.toExtendedJSON=function(e){if(e&&e.relaxed)return this.toNumber();return{$numberLong:this.toString()}};e.fromExtendedJSON=function(t,r){var n=e.fromString(t.$numberLong);return r&&r.relaxed?n.toNumber():n};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){return'new Long("'.concat(this.toString(),'"').concat(this.unsigned?", true":"",")")};e.TWO_PWR_24=e.fromInt(s);e.MAX_UNSIGNED_VALUE=e.fromBits(4294967295|0,4294967295|0,true);e.ZERO=e.fromInt(0);e.UZERO=e.fromInt(0,true);e.ONE=e.fromInt(1);e.UONE=e.fromInt(1,true);e.NEG_ONE=e.fromInt(-1);e.MAX_VALUE=e.fromBits(4294967295|0,2147483647|0,false);e.MIN_VALUE=e.fromBits(0,2147483648|0,false);return e}();t.Long=d;Object.defineProperty(d.prototype,"__isLong__",{value:true});Object.defineProperty(d.prototype,"_bsontype",{value:"Long"})},"./node_modules/bson/lib/map.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.Map=void 0;var n=r("./node_modules/bson/lib/utils/global.js");var i;t.Map=i;var o=(0,n.getGlobal)();if(o.Map){t.Map=i=o.Map}else{t.Map=i=function(){function e(e){if(e===void 0){e=[]}this._keys=[];this._values={};for(var t=0;t<e.length;t++){if(e[t]==null)continue;var r=e[t];var n=r[0];var i=r[1];this._keys.push(n);this._values[n]={v:i,i:this._keys.length-1}}}e.prototype.clear=function(){this._keys=[];this._values={}};e.prototype.delete=function(e){var t=this._values[e];if(t==null)return false;delete this._values[e];this._keys.splice(t.i,1);return true};e.prototype.entries=function(){var e=this;var t=0;return{next:function(){var r=e._keys[t++];return{value:r!==undefined?[r,e._values[r].v]:undefined,done:r!==undefined?false:true}}}};e.prototype.forEach=function(e,t){t=t||this;for(var r=0;r<this._keys.length;r++){var n=this._keys[r];e.call(t,this._values[n].v,n,t)}};e.prototype.get=function(e){return this._values[e]?this._values[e].v:undefined};e.prototype.has=function(e){return this._values[e]!=null};e.prototype.keys=function(){var e=this;var t=0;return{next:function(){var r=e._keys[t++];return{value:r!==undefined?r:undefined,done:r!==undefined?false:true}}}};e.prototype.set=function(e,t){if(this._values[e]){this._values[e].v=t;return this}this._keys.push(e);this._values[e]={v:t,i:this._keys.length-1};return this};e.prototype.values=function(){var e=this;var t=0;return{next:function(){var r=e._keys[t++];return{value:r!==undefined?e._values[r].v:undefined,done:r!==undefined?false:true}}}};Object.defineProperty(e.prototype,"size",{get:function(){return this._keys.length},enumerable:false,configurable:true});return e}()}},"./node_modules/bson/lib/max_key.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.MaxKey=void 0;var r=function(){function e(){if(!(this instanceof e))return new e}e.prototype.toExtendedJSON=function(){return{$maxKey:1}};e.fromExtendedJSON=function(){return new e};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){return"new MaxKey()"};return e}();t.MaxKey=r;Object.defineProperty(r.prototype,"_bsontype",{value:"MaxKey"})},"./node_modules/bson/lib/min_key.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.MinKey=void 0;var r=function(){function e(){if(!(this instanceof e))return new e}e.prototype.toExtendedJSON=function(){return{$minKey:1}};e.fromExtendedJSON=function(){return new e};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){return"new MinKey()"};return e}();t.MinKey=r;Object.defineProperty(r.prototype,"_bsontype",{value:"MinKey"})},"./node_modules/bson/lib/objectid.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.ObjectId=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/ensure_buffer.js");var o=r("./node_modules/bson/lib/error.js");var s=r("./node_modules/bson/lib/parser/utils.js");var u=new RegExp("^[0-9a-fA-F]{24}$");var f=null;var a=Symbol("id");var l=function(){function e(t){if(!(this instanceof e))return new e(t);var r;if(typeof t==="object"&&t&&"id"in t){if(typeof t.id!=="string"&&!ArrayBuffer.isView(t.id)){throw new o.BSONTypeError("Argument passed in must have an id that is of type string or Buffer")}if("toHexString"in t&&typeof t.toHexString==="function"){r=n.Buffer.from(t.toHexString(),"hex")}else{r=t.id}}else{r=t}if(r==null||typeof r==="number"){this[a]=e.generate(typeof r==="number"?r:undefined)}else if(ArrayBuffer.isView(r)&&r.byteLength===12){this[a]=r instanceof n.Buffer?r:(0,i.ensureBuffer)(r)}else if(typeof r==="string"){if(r.length===12){var s=n.Buffer.from(r);if(s.byteLength===12){this[a]=s}else{throw new o.BSONTypeError("Argument passed in must be a string of 12 bytes")}}else if(r.length===24&&u.test(r)){this[a]=n.Buffer.from(r,"hex")}else{throw new o.BSONTypeError("Argument passed in must be a string of 12 bytes or a string of 24 hex characters or an integer")}}else{throw new o.BSONTypeError("Argument passed in does not match the accepted types")}if(e.cacheHexString){this.__id=this.id.toString("hex")}}Object.defineProperty(e.prototype,"id",{get:function(){return this[a]},set:function(t){this[a]=t;if(e.cacheHexString){this.__id=t.toString("hex")}},enumerable:false,configurable:true});Object.defineProperty(e.prototype,"generationTime",{get:function(){return this.id.readInt32BE(0)},set:function(e){this.id.writeUInt32BE(e,0)},enumerable:false,configurable:true});e.prototype.toHexString=function(){if(e.cacheHexString&&this.__id){return this.__id}var t=this.id.toString("hex");if(e.cacheHexString&&!this.__id){this.__id=t}return t};e.getInc=function(){return e.index=(e.index+1)%16777215};e.generate=function(t){if("number"!==typeof t){t=Math.floor(Date.now()/1e3)}var r=e.getInc();var i=n.Buffer.alloc(12);i.writeUInt32BE(t,0);if(f===null){f=(0,s.randomBytes)(5)}i[4]=f[0];i[5]=f[1];i[6]=f[2];i[7]=f[3];i[8]=f[4];i[11]=r&255;i[10]=r>>8&255;i[9]=r>>16&255;return i};e.prototype.toString=function(e){if(e)return this.id.toString(e);return this.toHexString()};e.prototype.toJSON=function(){return this.toHexString()};e.prototype.equals=function(t){if(t===undefined||t===null){return false}if(t instanceof e){return this[a][11]===t[a][11]&&this[a].equals(t[a])}if(typeof t==="string"&&e.isValid(t)&&t.length===12&&(0,s.isUint8Array)(this.id)){return t===n.Buffer.prototype.toString.call(this.id,"latin1")}if(typeof t==="string"&&e.isValid(t)&&t.length===24){return t.toLowerCase()===this.toHexString()}if(typeof t==="string"&&e.isValid(t)&&t.length===12){return n.Buffer.from(t).equals(this.id)}if(typeof t==="object"&&"toHexString"in t&&typeof t.toHexString==="function"){var r=t.toHexString();var i=this.toHexString().toLowerCase();return typeof r==="string"&&r.toLowerCase()===i}return false};e.prototype.getTimestamp=function(){var e=new Date;var t=this.id.readUInt32BE(0);e.setTime(Math.floor(t)*1e3);return e};e.createPk=function(){return new e};e.createFromTime=function(t){var r=n.Buffer.from([0,0,0,0,0,0,0,0,0,0,0,0]);r.writeUInt32BE(t,0);return new e(r)};e.createFromHexString=function(t){if(typeof t==="undefined"||t!=null&&t.length!==24){throw new o.BSONTypeError("Argument passed in must be a single String of 12 bytes or a string of 24 hex characters")}return new e(n.Buffer.from(t,"hex"))};e.isValid=function(t){if(t==null)return false;try{new e(t);return true}catch(e){return false}};e.prototype.toExtendedJSON=function(){if(this.toHexString)return{$oid:this.toHexString()};return{$oid:this.toString("hex")}};e.fromExtendedJSON=function(t){return new e(t.$oid)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){return'new ObjectId("'.concat(this.toHexString(),'")')};e.index=Math.floor(Math.random()*16777215);return e}();t.ObjectId=l;Object.defineProperty(l.prototype,"generate",{value:(0,s.deprecate)((function(e){return l.generate(e)}),"Please use the static `ObjectId.generate(time)` instead")});Object.defineProperty(l.prototype,"getInc",{value:(0,s.deprecate)((function(){return l.getInc()}),"Please use the static `ObjectId.getInc()` instead")});Object.defineProperty(l.prototype,"get_inc",{value:(0,s.deprecate)((function(){return l.getInc()}),"Please use the static `ObjectId.getInc()` instead")});Object.defineProperty(l,"get_inc",{value:(0,s.deprecate)((function(){return l.getInc()}),"Please use the static `ObjectId.getInc()` instead")});Object.defineProperty(l.prototype,"_bsontype",{value:"ObjectID"})},"./node_modules/bson/lib/parser/calculate_size.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.calculateObjectSize=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/binary.js");var o=r("./node_modules/bson/lib/constants.js");var s=r("./node_modules/bson/lib/parser/utils.js");function u(e,t,r){var n=4+1;if(Array.isArray(e)){for(var i=0;i<e.length;i++){n+=f(i.toString(),e[i],t,true,r)}}else{if(typeof(e===null||e===void 0?void 0:e.toBSON)==="function"){e=e.toBSON()}for(var o in e){n+=f(o,e[o],t,false,r)}}return n}t.calculateObjectSize=u;function f(e,t,r,f,a){if(r===void 0){r=false}if(f===void 0){f=false}if(a===void 0){a=false}if(typeof(t===null||t===void 0?void 0:t.toBSON)==="function"){t=t.toBSON()}switch(typeof t){case"string":return 1+n.Buffer.byteLength(e,"utf8")+1+4+n.Buffer.byteLength(t,"utf8")+1;case"number":if(Math.floor(t)===t&&t>=o.JS_INT_MIN&&t<=o.JS_INT_MAX){if(t>=o.BSON_INT32_MIN&&t<=o.BSON_INT32_MAX){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(4+1)}else{return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(8+1)}}else{return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(8+1)}case"undefined":if(f||!a)return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1;return 0;case"boolean":return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(1+1);case"object":if(t==null||t["_bsontype"]==="MinKey"||t["_bsontype"]==="MaxKey"){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1}else if(t["_bsontype"]==="ObjectId"||t["_bsontype"]==="ObjectID"){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(12+1)}else if(t instanceof Date||(0,s.isDate)(t)){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(8+1)}else if(ArrayBuffer.isView(t)||t instanceof ArrayBuffer||(0,s.isAnyArrayBuffer)(t)){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(1+4+1)+t.byteLength}else if(t["_bsontype"]==="Long"||t["_bsontype"]==="Double"||t["_bsontype"]==="Timestamp"){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(8+1)}else if(t["_bsontype"]==="Decimal128"){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(16+1)}else if(t["_bsontype"]==="Code"){if(t.scope!=null&&Object.keys(t.scope).length>0){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+4+4+n.Buffer.byteLength(t.code.toString(),"utf8")+1+u(t.scope,r,a)}else{return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+4+n.Buffer.byteLength(t.code.toString(),"utf8")+1}}else if(t["_bsontype"]==="Binary"){var l=t;if(l.sub_type===i.Binary.SUBTYPE_BYTE_ARRAY){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(l.position+1+4+1+4)}else{return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+(l.position+1+4+1)}}else if(t["_bsontype"]==="Symbol"){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+n.Buffer.byteLength(t.value,"utf8")+4+1+1}else if(t["_bsontype"]==="DBRef"){var c=Object.assign({$ref:t.collection,$id:t.oid},t.fields);if(t.db!=null){c["$db"]=t.db}return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+u(c,r,a)}else if(t instanceof RegExp||(0,s.isRegExp)(t)){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+n.Buffer.byteLength(t.source,"utf8")+1+(t.global?1:0)+(t.ignoreCase?1:0)+(t.multiline?1:0)+1}else if(t["_bsontype"]==="BSONRegExp"){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+n.Buffer.byteLength(t.pattern,"utf8")+1+n.Buffer.byteLength(t.options,"utf8")+1}else{return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+u(t,r,a)+1}case"function":if(t instanceof RegExp||(0,s.isRegExp)(t)||String.call(t)==="[object RegExp]"){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+n.Buffer.byteLength(t.source,"utf8")+1+(t.global?1:0)+(t.ignoreCase?1:0)+(t.multiline?1:0)+1}else{if(r&&t.scope!=null&&Object.keys(t.scope).length>0){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+4+4+n.Buffer.byteLength((0,s.normalizedFunctionString)(t),"utf8")+1+u(t.scope,r,a)}else if(r){return(e!=null?n.Buffer.byteLength(e,"utf8")+1:0)+1+4+n.Buffer.byteLength((0,s.normalizedFunctionString)(t),"utf8")+1}}}return 0}},"./node_modules/bson/lib/parser/deserializer.js":function(e,t,r){var n=this&&this.__assign||function(){n=Object.assign||function(e){for(var t,r=1,n=arguments.length;r<n;r++){t=arguments[r];for(var i in t)if(Object.prototype.hasOwnProperty.call(t,i))e[i]=t[i]}return e};return n.apply(this,arguments)};Object.defineProperty(t,"__esModule",{value:true});t.deserialize=void 0;var i=r("buffer");var o=r("./node_modules/bson/lib/binary.js");var s=r("./node_modules/bson/lib/code.js");var u=r("./node_modules/bson/lib/constants.js");var f=r("./node_modules/bson/lib/db_ref.js");var a=r("./node_modules/bson/lib/decimal128.js");var l=r("./node_modules/bson/lib/double.js");var c=r("./node_modules/bson/lib/error.js");var d=r("./node_modules/bson/lib/int_32.js");var p=r("./node_modules/bson/lib/long.js");var b=r("./node_modules/bson/lib/max_key.js");var h=r("./node_modules/bson/lib/min_key.js");var _=r("./node_modules/bson/lib/objectid.js");var y=r("./node_modules/bson/lib/regexp.js");var g=r("./node_modules/bson/lib/symbol.js");var v=r("./node_modules/bson/lib/timestamp.js");var B=r("./node_modules/bson/lib/validate_utf8.js");var O=p.Long.fromNumber(u.JS_INT_MAX);var m=p.Long.fromNumber(u.JS_INT_MIN);var N={};function S(e,t,r){t=t==null?{}:t;var n=t&&t.index?t.index:0;var i=e[n]|e[n+1]<<8|e[n+2]<<16|e[n+3]<<24;if(i<5){throw new c.BSONError("bson size must be >= 5, is ".concat(i))}if(t.allowObjectSmallerThanBufferSize&&e.length<i){throw new c.BSONError("buffer length ".concat(e.length," must be >= bson size ").concat(i))}if(!t.allowObjectSmallerThanBufferSize&&e.length!==i){throw new c.BSONError("buffer length ".concat(e.length," must === bson size ").concat(i))}if(i+n>e.byteLength){throw new c.BSONError("(bson size ".concat(i," + options.index ").concat(n," must be <= buffer length ").concat(e.byteLength,")"))}if(e[n+i-1]!==0){throw new c.BSONError("One object, sized correctly, with a spot for an EOO, but the EOO isn't 0x00")}return E(e,n,t,r)}t.deserialize=S;var A=/^\$ref$|^\$id$|^\$db$/;function E(e,t,r,S){if(S===void 0){S=false}var j=r["evalFunctions"]==null?false:r["evalFunctions"];var D=r["cacheFunctions"]==null?false:r["cacheFunctions"];var I=r["fieldsAsRaw"]==null?null:r["fieldsAsRaw"];var x=r["raw"]==null?false:r["raw"];var U=typeof r["bsonRegExp"]==="boolean"?r["bsonRegExp"]:false;var L=r["promoteBuffers"]==null?false:r["promoteBuffers"];var R=r["promoteLongs"]==null?true:r["promoteLongs"];var P=r["promoteValues"]==null?true:r["promoteValues"];var M=r.validation==null?{utf8:true}:r.validation;var Y=true;var $;var C=new Set;var J=M.utf8;if(typeof J==="boolean"){$=J}else{Y=false;var z=Object.keys(J).map((function(e){return J[e]}));if(z.length===0){throw new c.BSONError("UTF-8 validation setting cannot be empty")}if(typeof z[0]!=="boolean"){throw new c.BSONError("Invalid UTF-8 validation option, must specify boolean values")}$=z[0];if(!z.every((function(e){return e===$}))){throw new c.BSONError("Invalid UTF-8 validation option - keys must be all true or all false")}}if(!Y){for(var F=0,k=Object.keys(J);F<k.length;F++){var K=k[F];C.add(K)}}var V=t;if(e.length<5)throw new c.BSONError("corrupt bson message < 5 bytes long");var q=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(q<5||q>e.length)throw new c.BSONError("corrupt bson message");var H=S?[]:{};var X=0;var G=false;var Z=S?false:null;var W=new DataView(e.buffer,e.byteOffset,e.byteLength);while(!G){var Q=e[t++];if(Q===0)break;var ee=t;while(e[ee]!==0&&ee<e.length){ee++}if(ee>=e.byteLength)throw new c.BSONError("Bad BSON Document: illegal CString");var te=S?X++:e.toString("utf8",t,ee);var re=true;if(Y||C.has(te)){re=$}else{re=!$}if(Z!==false&&te[0]==="$"){Z=A.test(te)}var ne=void 0;t=ee+1;if(Q===u.BSON_DATA_STRING){var ie=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(ie<=0||ie>e.length-t||e[t+ie-1]!==0){throw new c.BSONError("bad string length in bson")}ne=T(e,t,t+ie-1,re);t=t+ie}else if(Q===u.BSON_DATA_OID){var oe=i.Buffer.alloc(12);e.copy(oe,0,t,t+12);ne=new _.ObjectId(oe);t=t+12}else if(Q===u.BSON_DATA_INT&&P===false){ne=new d.Int32(e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24)}else if(Q===u.BSON_DATA_INT){ne=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24}else if(Q===u.BSON_DATA_NUMBER&&P===false){ne=new l.Double(W.getFloat64(t,true));t=t+8}else if(Q===u.BSON_DATA_NUMBER){ne=W.getFloat64(t,true);t=t+8}else if(Q===u.BSON_DATA_DATE){var se=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;var ue=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;ne=new Date(new p.Long(se,ue).toNumber())}else if(Q===u.BSON_DATA_BOOLEAN){if(e[t]!==0&&e[t]!==1)throw new c.BSONError("illegal boolean type value");ne=e[t++]===1}else if(Q===u.BSON_DATA_OBJECT){var fe=t;var ae=e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24;if(ae<=0||ae>e.length-t)throw new c.BSONError("bad embedded document length in bson");if(x){ne=e.slice(t,t+ae)}else{var le=r;if(!Y){le=n(n({},r),{validation:{utf8:re}})}ne=E(e,fe,le,false)}t=t+ae}else if(Q===u.BSON_DATA_ARRAY){var fe=t;var ae=e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24;var ce=r;var de=t+ae;if(I&&I[te]){ce={};for(var pe in r){ce[pe]=r[pe]}ce["raw"]=true}if(!Y){ce=n(n({},ce),{validation:{utf8:re}})}ne=E(e,fe,ce,true);t=t+ae;if(e[t-1]!==0)throw new c.BSONError("invalid array terminator byte");if(t!==de)throw new c.BSONError("corrupted array bson")}else if(Q===u.BSON_DATA_UNDEFINED){ne=undefined}else if(Q===u.BSON_DATA_NULL){ne=null}else if(Q===u.BSON_DATA_LONG){var se=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;var ue=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;var be=new p.Long(se,ue);if(R&&P===true){ne=be.lessThanOrEqual(O)&&be.greaterThanOrEqual(m)?be.toNumber():be}else{ne=be}}else if(Q===u.BSON_DATA_DECIMAL128){var he=i.Buffer.alloc(16);e.copy(he,0,t,t+16);t=t+16;var _e=new a.Decimal128(he);if("toObject"in _e&&typeof _e.toObject==="function"){ne=_e.toObject()}else{ne=_e}}else if(Q===u.BSON_DATA_BINARY){var ye=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;var ge=ye;var ve=e[t++];if(ye<0)throw new c.BSONError("Negative binary type element size found");if(ye>e.byteLength)throw new c.BSONError("Binary type size larger than document size");if(e["slice"]!=null){if(ve===o.Binary.SUBTYPE_BYTE_ARRAY){ye=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(ye<0)throw new c.BSONError("Negative binary type element size found for subtype 0x02");if(ye>ge-4)throw new c.BSONError("Binary type with subtype 0x02 contains too long binary size");if(ye<ge-4)throw new c.BSONError("Binary type with subtype 0x02 contains too short binary size")}if(L&&P){ne=e.slice(t,t+ye)}else{ne=new o.Binary(e.slice(t,t+ye),ve)}}else{var Be=i.Buffer.alloc(ye);if(ve===o.Binary.SUBTYPE_BYTE_ARRAY){ye=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(ye<0)throw new c.BSONError("Negative binary type element size found for subtype 0x02");if(ye>ge-4)throw new c.BSONError("Binary type with subtype 0x02 contains too long binary size");if(ye<ge-4)throw new c.BSONError("Binary type with subtype 0x02 contains too short binary size")}for(ee=0;ee<ye;ee++){Be[ee]=e[t+ee]}if(L&&P){ne=Be}else{ne=new o.Binary(Be,ve)}}t=t+ye}else if(Q===u.BSON_DATA_REGEXP&&U===false){ee=t;while(e[ee]!==0&&ee<e.length){ee++}if(ee>=e.length)throw new c.BSONError("Bad BSON Document: illegal CString");var Oe=e.toString("utf8",t,ee);t=ee+1;ee=t;while(e[ee]!==0&&ee<e.length){ee++}if(ee>=e.length)throw new c.BSONError("Bad BSON Document: illegal CString");var me=e.toString("utf8",t,ee);t=ee+1;var Ne=new Array(me.length);for(ee=0;ee<me.length;ee++){switch(me[ee]){case"m":Ne[ee]="m";break;case"s":Ne[ee]="g";break;case"i":Ne[ee]="i";break}}ne=new RegExp(Oe,Ne.join(""))}else if(Q===u.BSON_DATA_REGEXP&&U===true){ee=t;while(e[ee]!==0&&ee<e.length){ee++}if(ee>=e.length)throw new c.BSONError("Bad BSON Document: illegal CString");var Oe=e.toString("utf8",t,ee);t=ee+1;ee=t;while(e[ee]!==0&&ee<e.length){ee++}if(ee>=e.length)throw new c.BSONError("Bad BSON Document: illegal CString");var me=e.toString("utf8",t,ee);t=ee+1;ne=new y.BSONRegExp(Oe,me)}else if(Q===u.BSON_DATA_SYMBOL){var ie=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(ie<=0||ie>e.length-t||e[t+ie-1]!==0){throw new c.BSONError("bad string length in bson")}var Se=T(e,t,t+ie-1,re);ne=P?Se:new g.BSONSymbol(Se);t=t+ie}else if(Q===u.BSON_DATA_TIMESTAMP){var se=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;var ue=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;ne=new v.Timestamp(se,ue)}else if(Q===u.BSON_DATA_MIN_KEY){ne=new h.MinKey}else if(Q===u.BSON_DATA_MAX_KEY){ne=new b.MaxKey}else if(Q===u.BSON_DATA_CODE){var ie=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(ie<=0||ie>e.length-t||e[t+ie-1]!==0){throw new c.BSONError("bad string length in bson")}var Ae=T(e,t,t+ie-1,re);if(j){if(D){ne=w(Ae,N,H)}else{ne=w(Ae)}}else{ne=new s.Code(Ae)}t=t+ie}else if(Q===u.BSON_DATA_CODE_W_SCOPE){var Ee=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(Ee<4+4+4+1){throw new c.BSONError("code_w_scope total size shorter minimum expected length")}var ie=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(ie<=0||ie>e.length-t||e[t+ie-1]!==0){throw new c.BSONError("bad string length in bson")}var Ae=T(e,t,t+ie-1,re);t=t+ie;var fe=t;var ae=e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24;var we=E(e,fe,r,false);t=t+ae;if(Ee<4+4+ae+ie){throw new c.BSONError("code_w_scope total size is too short, truncating scope")}if(Ee>4+4+ae+ie){throw new c.BSONError("code_w_scope total size is too long, clips outer document")}if(j){if(D){ne=w(Ae,N,H)}else{ne=w(Ae)}ne.scope=we}else{ne=new s.Code(Ae,we)}}else if(Q===u.BSON_DATA_DBPOINTER){var ie=e[t++]|e[t++]<<8|e[t++]<<16|e[t++]<<24;if(ie<=0||ie>e.length-t||e[t+ie-1]!==0)throw new c.BSONError("bad string length in bson");if(M!=null&&M.utf8){if(!(0,B.validateUtf8)(e,t,t+ie-1)){throw new c.BSONError("Invalid UTF-8 string in BSON document")}}var Te=e.toString("utf8",t,t+ie-1);t=t+ie;var je=i.Buffer.alloc(12);e.copy(je,0,t,t+12);var oe=new _.ObjectId(je);t=t+12;ne=new f.DBRef(Te,oe)}else{throw new c.BSONError("Detected unknown BSON type ".concat(Q.toString(16),' for fieldname "').concat(te,'"'))}if(te==="__proto__"){Object.defineProperty(H,te,{value:ne,writable:true,enumerable:true,configurable:true})}else{H[te]=ne}}if(q!==t-V){if(S)throw new c.BSONError("corrupt array bson");throw new c.BSONError("corrupt object bson")}if(!Z)return H;if((0,f.isDBRefLike)(H)){var De=Object.assign({},H);delete De.$ref;delete De.$id;delete De.$db;return new f.DBRef(H.$ref,H.$id,H.$db,De)}return H}function w(e,t,r){if(!t)return new Function(e);if(t[e]==null){t[e]=new Function(e)}return t[e].bind(r)}function T(e,t,r,n){var i=e.toString("utf8",t,r);if(n){for(var o=0;o<i.length;o++){if(i.charCodeAt(o)===65533){if(!(0,B.validateUtf8)(e,t,r)){throw new c.BSONError("Invalid UTF-8 string in BSON document")}break}}}return i}},"./node_modules/bson/lib/parser/serializer.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.serializeInto=void 0;var n=r("./node_modules/bson/lib/binary.js");var i=r("./node_modules/bson/lib/constants.js");var o=r("./node_modules/bson/lib/ensure_buffer.js");var s=r("./node_modules/bson/lib/error.js");var u=r("./node_modules/bson/lib/extended_json.js");var f=r("./node_modules/bson/lib/long.js");var a=r("./node_modules/bson/lib/map.js");var l=r("./node_modules/bson/lib/parser/utils.js");var c=/\x00/;var d=new Set(["$db","$ref","$id","$clusterTime"]);function p(e,t,r,n,o){e[n++]=i.BSON_DATA_STRING;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s+1;e[n-1]=0;var u=e.write(r,n+4,undefined,"utf8");e[n+3]=u+1>>24&255;e[n+2]=u+1>>16&255;e[n+1]=u+1>>8&255;e[n]=u+1&255;n=n+4+u;e[n++]=0;return n}var b=new Uint8Array(8);var h=new DataView(b.buffer,b.byteOffset,b.byteLength);function _(e,t,r,n,o){if(Number.isInteger(r)&&r>=i.BSON_INT32_MIN&&r<=i.BSON_INT32_MAX){e[n++]=i.BSON_DATA_INT;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;e[n++]=r&255;e[n++]=r>>8&255;e[n++]=r>>16&255;e[n++]=r>>24&255}else{e[n++]=i.BSON_DATA_NUMBER;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;h.setFloat64(0,r,true);e.set(b,n);n=n+8}return n}function y(e,t,r,n,o){e[n++]=i.BSON_DATA_NULL;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;return n}function g(e,t,r,n,o){e[n++]=i.BSON_DATA_BOOLEAN;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;e[n++]=r?1:0;return n}function v(e,t,r,n,o){e[n++]=i.BSON_DATA_DATE;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;var u=f.Long.fromNumber(r.getTime());var a=u.getLowBits();var l=u.getHighBits();e[n++]=a&255;e[n++]=a>>8&255;e[n++]=a>>16&255;e[n++]=a>>24&255;e[n++]=l&255;e[n++]=l>>8&255;e[n++]=l>>16&255;e[n++]=l>>24&255;return n}function B(e,t,r,n,o){e[n++]=i.BSON_DATA_REGEXP;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;if(r.source&&r.source.match(c)!=null){throw Error("value "+r.source+" must not contain null bytes")}n=n+e.write(r.source,n,undefined,"utf8");e[n++]=0;if(r.ignoreCase)e[n++]=105;if(r.global)e[n++]=115;if(r.multiline)e[n++]=109;e[n++]=0;return n}function O(e,t,r,n,o){e[n++]=i.BSON_DATA_REGEXP;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;if(r.pattern.match(c)!=null){throw Error("pattern "+r.pattern+" must not contain null bytes")}n=n+e.write(r.pattern,n,undefined,"utf8");e[n++]=0;n=n+e.write(r.options.split("").sort().join(""),n,undefined,"utf8");e[n++]=0;return n}function m(e,t,r,n,o){if(r===null){e[n++]=i.BSON_DATA_NULL}else if(r._bsontype==="MinKey"){e[n++]=i.BSON_DATA_MIN_KEY}else{e[n++]=i.BSON_DATA_MAX_KEY}var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;return n}function N(e,t,r,n,o){e[n++]=i.BSON_DATA_OID;var u=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+u;e[n++]=0;if(typeof r.id==="string"){e.write(r.id,n,undefined,"binary")}else if((0,l.isUint8Array)(r.id)){e.set(r.id.subarray(0,12),n)}else{throw new s.BSONTypeError("object ["+JSON.stringify(r)+"] is not a valid ObjectId")}return n+12}function S(e,t,r,n,s){e[n++]=i.BSON_DATA_BINARY;var u=!s?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+u;e[n++]=0;var f=r.length;e[n++]=f&255;e[n++]=f>>8&255;e[n++]=f>>16&255;e[n++]=f>>24&255;e[n++]=i.BSON_BINARY_SUBTYPE_DEFAULT;e.set((0,o.ensureBuffer)(r),n);n=n+f;return n}function A(e,t,r,n,o,u,f,a,l,c){if(o===void 0){o=false}if(u===void 0){u=0}if(f===void 0){f=false}if(a===void 0){a=true}if(l===void 0){l=false}if(c===void 0){c=[]}for(var d=0;d<c.length;d++){if(c[d]===r)throw new s.BSONError("cyclic dependency detected")}c.push(r);e[n++]=Array.isArray(r)?i.BSON_DATA_ARRAY:i.BSON_DATA_OBJECT;var p=!l?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+p;e[n++]=0;var b=R(e,r,o,n,u+1,f,a,c);c.pop();return b}function E(e,t,r,n,o){e[n++]=i.BSON_DATA_DECIMAL128;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;e.set(r.bytes.subarray(0,16),n);return n+16}function w(e,t,r,n,o){e[n++]=r._bsontype==="Long"?i.BSON_DATA_LONG:i.BSON_DATA_TIMESTAMP;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;var u=r.getLowBits();var f=r.getHighBits();e[n++]=u&255;e[n++]=u>>8&255;e[n++]=u>>16&255;e[n++]=u>>24&255;e[n++]=f&255;e[n++]=f>>8&255;e[n++]=f>>16&255;e[n++]=f>>24&255;return n}function T(e,t,r,n,o){r=r.valueOf();e[n++]=i.BSON_DATA_INT;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;e[n++]=r&255;e[n++]=r>>8&255;e[n++]=r>>16&255;e[n++]=r>>24&255;return n}function j(e,t,r,n,o){e[n++]=i.BSON_DATA_NUMBER;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;h.setFloat64(0,r.value,true);e.set(b,n);n=n+8;return n}function D(e,t,r,n,o,s,u){if(o===void 0){o=false}if(s===void 0){s=0}e[n++]=i.BSON_DATA_CODE;var f=!u?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+f;e[n++]=0;var a=(0,l.normalizedFunctionString)(r);var c=e.write(a,n+4,undefined,"utf8")+1;e[n]=c&255;e[n+1]=c>>8&255;e[n+2]=c>>16&255;e[n+3]=c>>24&255;n=n+4+c-1;e[n++]=0;return n}function I(e,t,r,n,o,s,u,f,a){if(o===void 0){o=false}if(s===void 0){s=0}if(u===void 0){u=false}if(f===void 0){f=true}if(a===void 0){a=false}if(r.scope&&typeof r.scope==="object"){e[n++]=i.BSON_DATA_CODE_W_SCOPE;var l=!a?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+l;e[n++]=0;var c=n;var d=typeof r.code==="string"?r.code:r.code.toString();n=n+4;var p=e.write(d,n+4,undefined,"utf8")+1;e[n]=p&255;e[n+1]=p>>8&255;e[n+2]=p>>16&255;e[n+3]=p>>24&255;e[n+4+p-1]=0;n=n+p+4;var b=R(e,r.scope,o,n,s+1,u,f);n=b-1;var h=b-c;e[c++]=h&255;e[c++]=h>>8&255;e[c++]=h>>16&255;e[c++]=h>>24&255;e[n++]=0}else{e[n++]=i.BSON_DATA_CODE;var l=!a?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+l;e[n++]=0;var d=r.code.toString();var _=e.write(d,n+4,undefined,"utf8")+1;e[n]=_&255;e[n+1]=_>>8&255;e[n+2]=_>>16&255;e[n+3]=_>>24&255;n=n+4+_-1;e[n++]=0}return n}function x(e,t,r,o,s){e[o++]=i.BSON_DATA_BINARY;var u=!s?e.write(t,o,undefined,"utf8"):e.write(t,o,undefined,"ascii");o=o+u;e[o++]=0;var f=r.value(true);var a=r.position;if(r.sub_type===n.Binary.SUBTYPE_BYTE_ARRAY)a=a+4;e[o++]=a&255;e[o++]=a>>8&255;e[o++]=a>>16&255;e[o++]=a>>24&255;e[o++]=r.sub_type;if(r.sub_type===n.Binary.SUBTYPE_BYTE_ARRAY){a=a-4;e[o++]=a&255;e[o++]=a>>8&255;e[o++]=a>>16&255;e[o++]=a>>24&255}e.set(f,o);o=o+r.position;return o}function U(e,t,r,n,o){e[n++]=i.BSON_DATA_SYMBOL;var s=!o?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+s;e[n++]=0;var u=e.write(r.value,n+4,undefined,"utf8")+1;e[n]=u&255;e[n+1]=u>>8&255;e[n+2]=u>>16&255;e[n+3]=u>>24&255;n=n+4+u-1;e[n++]=0;return n}function L(e,t,r,n,o,s,u){e[n++]=i.BSON_DATA_OBJECT;var f=!u?e.write(t,n,undefined,"utf8"):e.write(t,n,undefined,"ascii");n=n+f;e[n++]=0;var a=n;var l={$ref:r.collection||r.namespace,$id:r.oid};if(r.db!=null){l.$db=r.db}l=Object.assign(l,r.fields);var c=R(e,l,false,n,o+1,s);var d=c-a;e[a++]=d&255;e[a++]=d>>8&255;e[a++]=d>>16&255;e[a++]=d>>24&255;return c}function R(e,t,r,n,i,o,f,b){if(r===void 0){r=false}if(n===void 0){n=0}if(i===void 0){i=0}if(o===void 0){o=false}if(f===void 0){f=true}if(b===void 0){b=[]}n=n||0;b=b||[];b.push(t);var h=n+4;if(Array.isArray(t)){for(var R=0;R<t.length;R++){var P="".concat(R);var M=t[R];if(typeof(M===null||M===void 0?void 0:M.toBSON)==="function"){M=M.toBSON()}if(typeof M==="string"){h=p(e,P,M,h,true)}else if(typeof M==="number"){h=_(e,P,M,h,true)}else if(typeof M==="bigint"){throw new s.BSONTypeError("Unsupported type BigInt, please use Decimal128")}else if(typeof M==="boolean"){h=g(e,P,M,h,true)}else if(M instanceof Date||(0,l.isDate)(M)){h=v(e,P,M,h,true)}else if(M===undefined){h=y(e,P,M,h,true)}else if(M===null){h=y(e,P,M,h,true)}else if(M["_bsontype"]==="ObjectId"||M["_bsontype"]==="ObjectID"){h=N(e,P,M,h,true)}else if((0,l.isUint8Array)(M)){h=S(e,P,M,h,true)}else if(M instanceof RegExp||(0,l.isRegExp)(M)){h=B(e,P,M,h,true)}else if(typeof M==="object"&&M["_bsontype"]==null){h=A(e,P,M,h,r,i,o,f,true,b)}else if(typeof M==="object"&&(0,u.isBSONType)(M)&&M._bsontype==="Decimal128"){h=E(e,P,M,h,true)}else if(M["_bsontype"]==="Long"||M["_bsontype"]==="Timestamp"){h=w(e,P,M,h,true)}else if(M["_bsontype"]==="Double"){h=j(e,P,M,h,true)}else if(typeof M==="function"&&o){h=D(e,P,M,h,r,i,true)}else if(M["_bsontype"]==="Code"){h=I(e,P,M,h,r,i,o,f,true)}else if(M["_bsontype"]==="Binary"){h=x(e,P,M,h,true)}else if(M["_bsontype"]==="Symbol"){h=U(e,P,M,h,true)}else if(M["_bsontype"]==="DBRef"){h=L(e,P,M,h,i,o,true)}else if(M["_bsontype"]==="BSONRegExp"){h=O(e,P,M,h,true)}else if(M["_bsontype"]==="Int32"){h=T(e,P,M,h,true)}else if(M["_bsontype"]==="MinKey"||M["_bsontype"]==="MaxKey"){h=m(e,P,M,h,true)}else if(typeof M["_bsontype"]!=="undefined"){throw new s.BSONTypeError("Unrecognized or invalid _bsontype: ".concat(String(M["_bsontype"])))}}}else if(t instanceof a.Map||(0,l.isMap)(t)){var Y=t.entries();var $=false;while(!$){var C=Y.next();$=!!C.done;if($)continue;var P=C.value[0];var M=C.value[1];var J=typeof M;if(typeof P==="string"&&!d.has(P)){if(P.match(c)!=null){throw Error("key "+P+" must not contain null bytes")}if(r){if("$"===P[0]){throw Error("key "+P+" must not start with '$'")}else if(~P.indexOf(".")){throw Error("key "+P+" must not contain '.'")}}}if(J==="string"){h=p(e,P,M,h)}else if(J==="number"){h=_(e,P,M,h)}else if(J==="bigint"||(0,l.isBigInt64Array)(M)||(0,l.isBigUInt64Array)(M)){throw new s.BSONTypeError("Unsupported type BigInt, please use Decimal128")}else if(J==="boolean"){h=g(e,P,M,h)}else if(M instanceof Date||(0,l.isDate)(M)){h=v(e,P,M,h)}else if(M===null||M===undefined&&f===false){h=y(e,P,M,h)}else if(M["_bsontype"]==="ObjectId"||M["_bsontype"]==="ObjectID"){h=N(e,P,M,h)}else if((0,l.isUint8Array)(M)){h=S(e,P,M,h)}else if(M instanceof RegExp||(0,l.isRegExp)(M)){h=B(e,P,M,h)}else if(J==="object"&&M["_bsontype"]==null){h=A(e,P,M,h,r,i,o,f,false,b)}else if(J==="object"&&M["_bsontype"]==="Decimal128"){h=E(e,P,M,h)}else if(M["_bsontype"]==="Long"||M["_bsontype"]==="Timestamp"){h=w(e,P,M,h)}else if(M["_bsontype"]==="Double"){h=j(e,P,M,h)}else if(M["_bsontype"]==="Code"){h=I(e,P,M,h,r,i,o,f)}else if(typeof M==="function"&&o){h=D(e,P,M,h,r,i,o)}else if(M["_bsontype"]==="Binary"){h=x(e,P,M,h)}else if(M["_bsontype"]==="Symbol"){h=U(e,P,M,h)}else if(M["_bsontype"]==="DBRef"){h=L(e,P,M,h,i,o)}else if(M["_bsontype"]==="BSONRegExp"){h=O(e,P,M,h)}else if(M["_bsontype"]==="Int32"){h=T(e,P,M,h)}else if(M["_bsontype"]==="MinKey"||M["_bsontype"]==="MaxKey"){h=m(e,P,M,h)}else if(typeof M["_bsontype"]!=="undefined"){throw new s.BSONTypeError("Unrecognized or invalid _bsontype: ".concat(String(M["_bsontype"])))}}}else{if(typeof(t===null||t===void 0?void 0:t.toBSON)==="function"){t=t.toBSON();if(t!=null&&typeof t!=="object"){throw new s.BSONTypeError("toBSON function did not return an object")}}for(var P in t){var M=t[P];if(typeof(M===null||M===void 0?void 0:M.toBSON)==="function"){M=M.toBSON()}var J=typeof M;if(typeof P==="string"&&!d.has(P)){if(P.match(c)!=null){throw Error("key "+P+" must not contain null bytes")}if(r){if("$"===P[0]){throw Error("key "+P+" must not start with '$'")}else if(~P.indexOf(".")){throw Error("key "+P+" must not contain '.'")}}}if(J==="string"){h=p(e,P,M,h)}else if(J==="number"){h=_(e,P,M,h)}else if(J==="bigint"){throw new s.BSONTypeError("Unsupported type BigInt, please use Decimal128")}else if(J==="boolean"){h=g(e,P,M,h)}else if(M instanceof Date||(0,l.isDate)(M)){h=v(e,P,M,h)}else if(M===undefined){if(f===false)h=y(e,P,M,h)}else if(M===null){h=y(e,P,M,h)}else if(M["_bsontype"]==="ObjectId"||M["_bsontype"]==="ObjectID"){h=N(e,P,M,h)}else if((0,l.isUint8Array)(M)){h=S(e,P,M,h)}else if(M instanceof RegExp||(0,l.isRegExp)(M)){h=B(e,P,M,h)}else if(J==="object"&&M["_bsontype"]==null){h=A(e,P,M,h,r,i,o,f,false,b)}else if(J==="object"&&M["_bsontype"]==="Decimal128"){h=E(e,P,M,h)}else if(M["_bsontype"]==="Long"||M["_bsontype"]==="Timestamp"){h=w(e,P,M,h)}else if(M["_bsontype"]==="Double"){h=j(e,P,M,h)}else if(M["_bsontype"]==="Code"){h=I(e,P,M,h,r,i,o,f)}else if(typeof M==="function"&&o){h=D(e,P,M,h,r,i,o)}else if(M["_bsontype"]==="Binary"){h=x(e,P,M,h)}else if(M["_bsontype"]==="Symbol"){h=U(e,P,M,h)}else if(M["_bsontype"]==="DBRef"){h=L(e,P,M,h,i,o)}else if(M["_bsontype"]==="BSONRegExp"){h=O(e,P,M,h)}else if(M["_bsontype"]==="Int32"){h=T(e,P,M,h)}else if(M["_bsontype"]==="MinKey"||M["_bsontype"]==="MaxKey"){h=m(e,P,M,h)}else if(typeof M["_bsontype"]!=="undefined"){throw new s.BSONTypeError("Unrecognized or invalid _bsontype: ".concat(String(M["_bsontype"])))}}}b.pop();e[h++]=0;var z=h-n;e[n++]=z&255;e[n++]=z>>8&255;e[n++]=z>>16&255;e[n++]=z>>24&255;return h}t.serializeInto=R},"./node_modules/bson/lib/parser/utils.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.deprecate=t.isObjectLike=t.isDate=t.haveBuffer=t.isMap=t.isRegExp=t.isBigUInt64Array=t.isBigInt64Array=t.isUint8Array=t.isAnyArrayBuffer=t.randomBytes=t.normalizedFunctionString=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/utils/global.js");function o(e){return e.toString().replace("function(","function (")}t.normalizedFunctionString=o;function s(){var e=(0,i.getGlobal)();return typeof e.navigator==="object"&&e.navigator.product==="ReactNative"}var u=function e(t){var r=s()?"BSON: For React Native please polyfill crypto.getRandomValues, e.g. using: https://www.npmjs.com/package/react-native-get-random-values.":"BSON: No cryptographic implementation for random bytes present, falling back to a less secure implementation.";console.warn(r);var i=n.Buffer.alloc(t);for(var o=0;o<t;++o)i[o]=Math.floor(Math.random()*256);return i};var f=function(){if(process.browser){if(typeof window!=="undefined"){var e=window.crypto||window.msCrypto;if(e&&e.getRandomValues){return function(t){return e.getRandomValues(n.Buffer.alloc(t))}}}if(typeof global!=="undefined"&&global.crypto&&global.crypto.getRandomValues){return function(e){return global.crypto.getRandomValues(n.Buffer.alloc(e))}}return u}else{var t=void 0;try{t=r("crypto").randomBytes}catch(e){}return t||u}};t.randomBytes=f();function a(e){return["[object ArrayBuffer]","[object SharedArrayBuffer]"].includes(Object.prototype.toString.call(e))}t.isAnyArrayBuffer=a;function l(e){return Object.prototype.toString.call(e)==="[object Uint8Array]"}t.isUint8Array=l;function c(e){return Object.prototype.toString.call(e)==="[object BigInt64Array]"}t.isBigInt64Array=c;function d(e){return Object.prototype.toString.call(e)==="[object BigUint64Array]"}t.isBigUInt64Array=d;function p(e){return Object.prototype.toString.call(e)==="[object RegExp]"}t.isRegExp=p;function b(e){return Object.prototype.toString.call(e)==="[object Map]"}t.isMap=b;function h(){return typeof global!=="undefined"&&typeof global.Buffer!=="undefined"}t.haveBuffer=h;function _(e){return y(e)&&Object.prototype.toString.call(e)==="[object Date]"}t.isDate=_;function y(e){return typeof e==="object"&&e!==null}t.isObjectLike=y;function g(e,t){var r=false;function n(){var n=[];for(var i=0;i<arguments.length;i++){n[i]=arguments[i]}if(!r){console.warn(t);r=true}return e.apply(this,n)}return n}t.deprecate=g},"./node_modules/bson/lib/regexp.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.BSONRegExp=void 0;var n=r("./node_modules/bson/lib/error.js");function i(e){return e.split("").sort().join("")}var o=function(){function e(t,r){if(!(this instanceof e))return new e(t,r);this.pattern=t;this.options=i(r!==null&&r!==void 0?r:"");if(this.pattern.indexOf("\0")!==-1){throw new n.BSONError("BSON Regex patterns cannot contain null bytes, found: ".concat(JSON.stringify(this.pattern)))}if(this.options.indexOf("\0")!==-1){throw new n.BSONError("BSON Regex options cannot contain null bytes, found: ".concat(JSON.stringify(this.options)))}for(var o=0;o<this.options.length;o++){if(!(this.options[o]==="i"||this.options[o]==="m"||this.options[o]==="x"||this.options[o]==="l"||this.options[o]==="s"||this.options[o]==="u")){throw new n.BSONError("The regular expression option [".concat(this.options[o],"] is not supported"))}}}e.parseOptions=function(e){return e?e.split("").sort().join(""):""};e.prototype.toExtendedJSON=function(e){e=e||{};if(e.legacy){return{$regex:this.pattern,$options:this.options}}return{$regularExpression:{pattern:this.pattern,options:this.options}}};e.fromExtendedJSON=function(t){if("$regex"in t){if(typeof t.$regex!=="string"){if(t.$regex._bsontype==="BSONRegExp"){return t}}else{return new e(t.$regex,e.parseOptions(t.$options))}}if("$regularExpression"in t){return new e(t.$regularExpression.pattern,e.parseOptions(t.$regularExpression.options))}throw new n.BSONTypeError("Unexpected BSONRegExp EJSON object form: ".concat(JSON.stringify(t)))};return e}();t.BSONRegExp=o;Object.defineProperty(o.prototype,"_bsontype",{value:"BSONRegExp"})},"./node_modules/bson/lib/symbol.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.BSONSymbol=void 0;var r=function(){function e(t){if(!(this instanceof e))return new e(t);this.value=t}e.prototype.valueOf=function(){return this.value};e.prototype.toString=function(){return this.value};e.prototype.inspect=function(){return'new BSONSymbol("'.concat(this.value,'")')};e.prototype.toJSON=function(){return this.value};e.prototype.toExtendedJSON=function(){return{$symbol:this.value}};e.fromExtendedJSON=function(t){return new e(t.$symbol)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};return e}();t.BSONSymbol=r;Object.defineProperty(r.prototype,"_bsontype",{value:"Symbol"})},"./node_modules/bson/lib/timestamp.js":function(e,t,r){var n=this&&this.__extends||function(){var e=function(t,r){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)if(Object.prototype.hasOwnProperty.call(t,r))e[r]=t[r]};return e(t,r)};return function(t,r){if(typeof r!=="function"&&r!==null)throw new TypeError("Class extends value "+String(r)+" is not a constructor or null");e(t,r);function n(){this.constructor=t}t.prototype=r===null?Object.create(r):(n.prototype=r.prototype,new n)}}();Object.defineProperty(t,"__esModule",{value:true});t.Timestamp=t.LongWithoutOverridesClass=void 0;var i=r("./node_modules/bson/lib/long.js");var o=r("./node_modules/bson/lib/parser/utils.js");t.LongWithoutOverridesClass=i.Long;var s=function(e){n(t,e);function t(r,n){var s=this;if(!(s instanceof t))return new t(r,n);if(i.Long.isLong(r)){s=e.call(this,r.low,r.high,true)||this}else if((0,o.isObjectLike)(r)&&typeof r.t!=="undefined"&&typeof r.i!=="undefined"){s=e.call(this,r.i,r.t,true)||this}else{s=e.call(this,r,n,true)||this}Object.defineProperty(s,"_bsontype",{value:"Timestamp",writable:false,configurable:false,enumerable:false});return s}t.prototype.toJSON=function(){return{$timestamp:this.toString()}};t.fromInt=function(e){return new t(i.Long.fromInt(e,true))};t.fromNumber=function(e){return new t(i.Long.fromNumber(e,true))};t.fromBits=function(e,r){return new t(e,r)};t.fromString=function(e,r){return new t(i.Long.fromString(e,true,r))};t.prototype.toExtendedJSON=function(){return{$timestamp:{t:this.high>>>0,i:this.low>>>0}}};t.fromExtendedJSON=function(e){return new t(e.$timestamp)};t.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};t.prototype.inspect=function(){return"new Timestamp({ t: ".concat(this.getHighBits(),", i: ").concat(this.getLowBits()," })")};t.MAX_VALUE=i.Long.MAX_UNSIGNED_VALUE;return t}(t.LongWithoutOverridesClass);t.Timestamp=s},"./node_modules/bson/lib/utils/global.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.getGlobal=void 0;function r(e){return e&&e.Math==Math&&e}function n(){return r(typeof globalThis==="object"&&globalThis)||r(typeof window==="object"&&window)||r(typeof self==="object"&&self)||r(typeof global==="object"&&global)||Function("return this")()}t.getGlobal=n},"./node_modules/bson/lib/uuid.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.UUID=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/ensure_buffer.js");var o=r("./node_modules/bson/lib/binary.js");var s=r("./node_modules/bson/lib/uuid_utils.js");var u=r("./node_modules/bson/lib/parser/utils.js");var f=r("./node_modules/bson/lib/error.js");var a=16;var l=Symbol("id");var c=function(){function e(t){if(typeof t==="undefined"){this.id=e.generate()}else if(t instanceof e){this[l]=n.Buffer.from(t.id);this.__id=t.__id}else if(ArrayBuffer.isView(t)&&t.byteLength===a){this.id=(0,i.ensureBuffer)(t)}else if(typeof t==="string"){this.id=(0,s.uuidHexStringToBuffer)(t)}else{throw new f.BSONTypeError("Argument passed in UUID constructor must be a UUID, a 16 byte Buffer or a 32/36 character hex string (dashes excluded/included, format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx).")}}Object.defineProperty(e.prototype,"id",{get:function(){return this[l]},set:function(t){this[l]=t;if(e.cacheHexString){this.__id=(0,s.bufferToUuidHexString)(t)}},enumerable:false,configurable:true});e.prototype.toHexString=function(t){if(t===void 0){t=true}if(e.cacheHexString&&this.__id){return this.__id}var r=(0,s.bufferToUuidHexString)(this.id,t);if(e.cacheHexString){this.__id=r}return r};e.prototype.toString=function(e){return e?this.id.toString(e):this.toHexString()};e.prototype.toJSON=function(){return this.toHexString()};e.prototype.equals=function(t){if(!t){return false}if(t instanceof e){return t.id.equals(this.id)}try{return new e(t).id.equals(this.id)}catch(e){return false}};e.prototype.toBinary=function(){return new o.Binary(this.id,o.Binary.SUBTYPE_UUID)};e.generate=function(){var e=(0,u.randomBytes)(a);e[6]=e[6]&15|64;e[8]=e[8]&63|128;return n.Buffer.from(e)};e.isValid=function(t){if(!t){return false}if(t instanceof e){return true}if(typeof t==="string"){return(0,s.uuidValidateString)(t)}if((0,u.isUint8Array)(t)){if(t.length!==a){return false}try{return parseInt(t[6].toString(16)[0],10)===o.Binary.SUBTYPE_UUID}catch(e){return false}}return false};e.createFromHexString=function(t){var r=(0,s.uuidHexStringToBuffer)(t);return new e(r)};e.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return this.inspect()};e.prototype.inspect=function(){return'new UUID("'.concat(this.toHexString(),'")')};return e}();t.UUID=c;Object.defineProperty(c.prototype,"_bsontype",{value:"UUID"})},"./node_modules/bson/lib/uuid_utils.js":(e,t,r)=>{Object.defineProperty(t,"__esModule",{value:true});t.bufferToUuidHexString=t.uuidHexStringToBuffer=t.uuidValidateString=void 0;var n=r("buffer");var i=r("./node_modules/bson/lib/error.js");var o=/^(?:[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|[0-9a-f]{12}4[0-9a-f]{3}[89ab][0-9a-f]{15})$/i;var s=function(e){return typeof e==="string"&&o.test(e)};t.uuidValidateString=s;var u=function(e){if(!(0,t.uuidValidateString)(e)){throw new i.BSONTypeError('UUID string representations must be a 32 or 36 character hex string (dashes excluded/included). Format: "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" or "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx".')}var r=e.replace(/-/g,"");return n.Buffer.from(r,"hex")};t.uuidHexStringToBuffer=u;var f=function(e,t){if(t===void 0){t=true}return t?e.toString("hex",0,4)+"-"+e.toString("hex",4,6)+"-"+e.toString("hex",6,8)+"-"+e.toString("hex",8,10)+"-"+e.toString("hex",10,16):e.toString("hex")};t.bufferToUuidHexString=f},"./node_modules/bson/lib/validate_utf8.js":(e,t)=>{Object.defineProperty(t,"__esModule",{value:true});t.validateUtf8=void 0;var r=128;var n=192;var i=224;var o=240;var s=248;var u=192;var f=224;var a=240;var l=128;function c(e,t,c){var d=0;for(var p=t;p<c;p+=1){var b=e[p];if(d){if((b&n)!==l){return false}d-=1}else if(b&r){if((b&i)===u){d=1}else if((b&o)===f){d=2}else if((b&s)===a){d=3}else{return false}}}return!d}t.validateUtf8=c},buffer:e=>{e.exports=require("buffer")},crypto:e=>{e.exports=require("crypto")}};var t={};function r(n){var i=t[n];if(i!==undefined){return i.exports}var o=t[n]={exports:{}};e[n].call(o.exports,o,o.exports,r);return o.exports}var n={};(()=>{var e=n;Object.defineProperty(e,"__esModule",{value:true});e.BSONRegExp=e.MaxKey=e.MinKey=e.Int32=e.Double=e.Timestamp=e.Long=e.UUID=e.ObjectId=e.Binary=e.DBRef=e.BSONSymbol=e.Map=e.Code=e.LongWithoutOverridesClass=e.EJSON=e.BSON_INT64_MIN=e.BSON_INT64_MAX=e.BSON_INT32_MIN=e.BSON_INT32_MAX=e.BSON_DATA_UNDEFINED=e.BSON_DATA_TIMESTAMP=e.BSON_DATA_SYMBOL=e.BSON_DATA_STRING=e.BSON_DATA_REGEXP=e.BSON_DATA_OID=e.BSON_DATA_OBJECT=e.BSON_DATA_NUMBER=e.BSON_DATA_NULL=e.BSON_DATA_MIN_KEY=e.BSON_DATA_MAX_KEY=e.BSON_DATA_LONG=e.BSON_DATA_INT=e.BSON_DATA_DECIMAL128=e.BSON_DATA_DBPOINTER=e.BSON_DATA_DATE=e.BSON_DATA_CODE_W_SCOPE=e.BSON_DATA_CODE=e.BSON_DATA_BOOLEAN=e.BSON_DATA_BINARY=e.BSON_DATA_ARRAY=e.BSON_BINARY_SUBTYPE_COLUMN=e.BSON_BINARY_SUBTYPE_ENCRYPTED=e.BSON_BINARY_SUBTYPE_UUID_NEW=e.BSON_BINARY_SUBTYPE_UUID=e.BSON_BINARY_SUBTYPE_USER_DEFINED=e.BSON_BINARY_SUBTYPE_MD5=e.BSON_BINARY_SUBTYPE_FUNCTION=e.BSON_BINARY_SUBTYPE_DEFAULT=e.BSON_BINARY_SUBTYPE_BYTE_ARRAY=void 0;e.deserializeStream=e.calculateObjectSize=e.deserialize=e.serializeWithBufferAndIndex=e.serialize=e.setInternalBufferSize=e.BSONTypeError=e.BSONError=e.ObjectID=e.Decimal128=void 0;var t=r("buffer");var i=r("./node_modules/bson/lib/binary.js");Object.defineProperty(e,"Binary",{enumerable:true,get:function(){return i.Binary}});var o=r("./node_modules/bson/lib/code.js");Object.defineProperty(e,"Code",{enumerable:true,get:function(){return o.Code}});var s=r("./node_modules/bson/lib/db_ref.js");Object.defineProperty(e,"DBRef",{enumerable:true,get:function(){return s.DBRef}});var u=r("./node_modules/bson/lib/decimal128.js");Object.defineProperty(e,"Decimal128",{enumerable:true,get:function(){return u.Decimal128}});var f=r("./node_modules/bson/lib/double.js");Object.defineProperty(e,"Double",{enumerable:true,get:function(){return f.Double}});var a=r("./node_modules/bson/lib/ensure_buffer.js");var l=r("./node_modules/bson/lib/extended_json.js");var c=r("./node_modules/bson/lib/int_32.js");Object.defineProperty(e,"Int32",{enumerable:true,get:function(){return c.Int32}});var d=r("./node_modules/bson/lib/long.js");Object.defineProperty(e,"Long",{enumerable:true,get:function(){return d.Long}});var p=r("./node_modules/bson/lib/map.js");Object.defineProperty(e,"Map",{enumerable:true,get:function(){return p.Map}});var b=r("./node_modules/bson/lib/max_key.js");Object.defineProperty(e,"MaxKey",{enumerable:true,get:function(){return b.MaxKey}});var h=r("./node_modules/bson/lib/min_key.js");Object.defineProperty(e,"MinKey",{enumerable:true,get:function(){return h.MinKey}});var _=r("./node_modules/bson/lib/objectid.js");Object.defineProperty(e,"ObjectId",{enumerable:true,get:function(){return _.ObjectId}});Object.defineProperty(e,"ObjectID",{enumerable:true,get:function(){return _.ObjectId}});var y=r("./node_modules/bson/lib/error.js");var g=r("./node_modules/bson/lib/parser/calculate_size.js");var v=r("./node_modules/bson/lib/parser/deserializer.js");var B=r("./node_modules/bson/lib/parser/serializer.js");var O=r("./node_modules/bson/lib/regexp.js");Object.defineProperty(e,"BSONRegExp",{enumerable:true,get:function(){return O.BSONRegExp}});var m=r("./node_modules/bson/lib/symbol.js");Object.defineProperty(e,"BSONSymbol",{enumerable:true,get:function(){return m.BSONSymbol}});var N=r("./node_modules/bson/lib/timestamp.js");Object.defineProperty(e,"Timestamp",{enumerable:true,get:function(){return N.Timestamp}});var S=r("./node_modules/bson/lib/uuid.js");Object.defineProperty(e,"UUID",{enumerable:true,get:function(){return S.UUID}});var A=r("./node_modules/bson/lib/binary.js");var E=r("./node_modules/bson/lib/code.js");var w=r("./node_modules/bson/lib/constants.js");Object.defineProperty(e,"BSON_BINARY_SUBTYPE_BYTE_ARRAY",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_BYTE_ARRAY}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_DEFAULT",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_DEFAULT}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_FUNCTION",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_FUNCTION}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_MD5",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_MD5}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_USER_DEFINED",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_USER_DEFINED}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_UUID",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_UUID}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_UUID_NEW",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_UUID_NEW}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_ENCRYPTED",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_ENCRYPTED}});Object.defineProperty(e,"BSON_BINARY_SUBTYPE_COLUMN",{enumerable:true,get:function(){return w.BSON_BINARY_SUBTYPE_COLUMN}});Object.defineProperty(e,"BSON_DATA_ARRAY",{enumerable:true,get:function(){return w.BSON_DATA_ARRAY}});Object.defineProperty(e,"BSON_DATA_BINARY",{enumerable:true,get:function(){return w.BSON_DATA_BINARY}});Object.defineProperty(e,"BSON_DATA_BOOLEAN",{enumerable:true,get:function(){return w.BSON_DATA_BOOLEAN}});Object.defineProperty(e,"BSON_DATA_CODE",{enumerable:true,get:function(){return w.BSON_DATA_CODE}});Object.defineProperty(e,"BSON_DATA_CODE_W_SCOPE",{enumerable:true,get:function(){return w.BSON_DATA_CODE_W_SCOPE}});Object.defineProperty(e,"BSON_DATA_DATE",{enumerable:true,get:function(){return w.BSON_DATA_DATE}});Object.defineProperty(e,"BSON_DATA_DBPOINTER",{enumerable:true,get:function(){return w.BSON_DATA_DBPOINTER}});Object.defineProperty(e,"BSON_DATA_DECIMAL128",{enumerable:true,get:function(){return w.BSON_DATA_DECIMAL128}});Object.defineProperty(e,"BSON_DATA_INT",{enumerable:true,get:function(){return w.BSON_DATA_INT}});Object.defineProperty(e,"BSON_DATA_LONG",{enumerable:true,get:function(){return w.BSON_DATA_LONG}});Object.defineProperty(e,"BSON_DATA_MAX_KEY",{enumerable:true,get:function(){return w.BSON_DATA_MAX_KEY}});Object.defineProperty(e,"BSON_DATA_MIN_KEY",{enumerable:true,get:function(){return w.BSON_DATA_MIN_KEY}});Object.defineProperty(e,"BSON_DATA_NULL",{enumerable:true,get:function(){return w.BSON_DATA_NULL}});Object.defineProperty(e,"BSON_DATA_NUMBER",{enumerable:true,get:function(){return w.BSON_DATA_NUMBER}});Object.defineProperty(e,"BSON_DATA_OBJECT",{enumerable:true,get:function(){return w.BSON_DATA_OBJECT}});Object.defineProperty(e,"BSON_DATA_OID",{enumerable:true,get:function(){return w.BSON_DATA_OID}});Object.defineProperty(e,"BSON_DATA_REGEXP",{enumerable:true,get:function(){return w.BSON_DATA_REGEXP}});Object.defineProperty(e,"BSON_DATA_STRING",{enumerable:true,get:function(){return w.BSON_DATA_STRING}});Object.defineProperty(e,"BSON_DATA_SYMBOL",{enumerable:true,get:function(){return w.BSON_DATA_SYMBOL}});Object.defineProperty(e,"BSON_DATA_TIMESTAMP",{enumerable:true,get:function(){return w.BSON_DATA_TIMESTAMP}});Object.defineProperty(e,"BSON_DATA_UNDEFINED",{enumerable:true,get:function(){return w.BSON_DATA_UNDEFINED}});Object.defineProperty(e,"BSON_INT32_MAX",{enumerable:true,get:function(){return w.BSON_INT32_MAX}});Object.defineProperty(e,"BSON_INT32_MIN",{enumerable:true,get:function(){return w.BSON_INT32_MIN}});Object.defineProperty(e,"BSON_INT64_MAX",{enumerable:true,get:function(){return w.BSON_INT64_MAX}});Object.defineProperty(e,"BSON_INT64_MIN",{enumerable:true,get:function(){return w.BSON_INT64_MIN}});var T=r("./node_modules/bson/lib/db_ref.js");var j=r("./node_modules/bson/lib/decimal128.js");var D=r("./node_modules/bson/lib/double.js");var I=r("./node_modules/bson/lib/extended_json.js");Object.defineProperty(e,"EJSON",{enumerable:true,get:function(){return I.EJSON}});var x=r("./node_modules/bson/lib/int_32.js");var U=r("./node_modules/bson/lib/long.js");var L=r("./node_modules/bson/lib/max_key.js");var R=r("./node_modules/bson/lib/min_key.js");var P=r("./node_modules/bson/lib/objectid.js");var M=r("./node_modules/bson/lib/regexp.js");var Y=r("./node_modules/bson/lib/symbol.js");var $=r("./node_modules/bson/lib/timestamp.js");Object.defineProperty(e,"LongWithoutOverridesClass",{enumerable:true,get:function(){return $.LongWithoutOverridesClass}});var C=r("./node_modules/bson/lib/uuid.js");var J=r("./node_modules/bson/lib/error.js");Object.defineProperty(e,"BSONError",{enumerable:true,get:function(){return J.BSONError}});Object.defineProperty(e,"BSONTypeError",{enumerable:true,get:function(){return J.BSONTypeError}});var z=1024*1024*17;var F=t.Buffer.alloc(z);function k(e){if(F.length<e){F=t.Buffer.alloc(e)}}e.setInternalBufferSize=k;function K(e,r){if(r===void 0){r={}}var n=typeof r.checkKeys==="boolean"?r.checkKeys:false;var i=typeof r.serializeFunctions==="boolean"?r.serializeFunctions:false;var o=typeof r.ignoreUndefined==="boolean"?r.ignoreUndefined:true;var s=typeof r.minInternalBufferSize==="number"?r.minInternalBufferSize:z;if(F.length<s){F=t.Buffer.alloc(s)}var u=(0,B.serializeInto)(F,e,n,0,0,i,o,[]);var f=t.Buffer.alloc(u);F.copy(f,0,0,f.length);return f}e.serialize=K;function V(e,t,r){if(r===void 0){r={}}var n=typeof r.checkKeys==="boolean"?r.checkKeys:false;var i=typeof r.serializeFunctions==="boolean"?r.serializeFunctions:false;var o=typeof r.ignoreUndefined==="boolean"?r.ignoreUndefined:true;var s=typeof r.index==="number"?r.index:0;var u=(0,B.serializeInto)(F,e,n,0,0,i,o);F.copy(t,s,0,u);return s+u-1}e.serializeWithBufferAndIndex=V;function q(e,r){if(r===void 0){r={}}return(0,v.deserialize)(e instanceof t.Buffer?e:(0,a.ensureBuffer)(e),r)}e.deserialize=q;function H(e,t){if(t===void 0){t={}}t=t||{};var r=typeof t.serializeFunctions==="boolean"?t.serializeFunctions:false;var n=typeof t.ignoreUndefined==="boolean"?t.ignoreUndefined:true;return(0,g.calculateObjectSize)(e,r,n)}e.calculateObjectSize=H;function X(e,t,r,n,i,o){var s=Object.assign({allowObjectSmallerThanBufferSize:true,index:0},o);var u=(0,a.ensureBuffer)(e);var f=t;for(var l=0;l<r;l++){var c=u[f]|u[f+1]<<8|u[f+2]<<16|u[f+3]<<24;s.index=f;n[i+l]=(0,v.deserialize)(u,s);f=f+c}return f}e.deserializeStream=X;var G={Binary:i.Binary,Code:o.Code,DBRef:s.DBRef,Decimal128:u.Decimal128,Double:f.Double,Int32:c.Int32,Long:d.Long,UUID:S.UUID,Map:p.Map,MaxKey:b.MaxKey,MinKey:h.MinKey,ObjectId:_.ObjectId,ObjectID:_.ObjectId,BSONRegExp:O.BSONRegExp,BSONSymbol:m.BSONSymbol,Timestamp:N.Timestamp,EJSON:l.EJSON,setInternalBufferSize:k,serialize:K,serializeWithBufferAndIndex:V,deserialize:q,calculateObjectSize:H,deserializeStream:X,BSONError:y.BSONError,BSONTypeError:y.BSONTypeError};e["default"]=G})();return n})()));